/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import net.java.dev.properties.util.ByteArrayWrapper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Panel;
import net.model3x.swing.beanprops.editors.AbstractEditor;

public class ImageSelectorEditor
extends AbstractEditor<ByteArrayWrapper, JComponent> {
    private M3Panel panel;
    private JLabel imageLabel;
    private ByteArrayWrapper value;
    private JButton button;
    private boolean hasChanges = false;

    @Override
    public ByteArrayWrapper getValueFromWidget() {
        return this.value;
    }

    @Override
    public void setValueInWidget(ByteArrayWrapper byteArrayWrapper) {
        this.value = byteArrayWrapper;
        if (this.imageLabel != null && byteArrayWrapper != null && byteArrayWrapper.getBuffer() != null) {
            this.imageLabel.setIcon(new ImageIcon(byteArrayWrapper.getBuffer()));
        }
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public JComponent initWidget() {
        this.panel = new M3Panel("fillx");
        this.button = new JButton(new FileChooserAction("Change"));
        this.imageLabel = new JLabel();
        if (this.value != null) {
            this.imageLabel.setIcon(new ImageIcon(this.value.getBuffer()));
        }
        this.imageLabel.setPreferredSize(new Dimension(200, 400));
        this.panel.add((Component)this.imageLabel);
        this.panel.add((Component)this.button);
        return this.panel;
    }

    class FileChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 4377386270269629176L;

        public FileChooserAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("jpg") || file.getName().endsWith("gif") || file.getName().endsWith("jpeg") || file.getName().endsWith("png");
                }

                @Override
                public String getDescription() {
                    return "Image Files";
                }
            });
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                FileInputStream fileInputStream = null;
                try {
                    int n2;
                    long l = file.length();
                    byte[] byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file);
                    int n3 = 0;
                    for (n2 = 0; n2 < byArray.length && (n3 = fileInputStream.read(byArray, n2, byArray.length - n2)) >= 0; n2 += n3) {
                    }
                    if (n2 < byArray.length) {
                        throw new IOException("Could not completely read file " + file.getName());
                    }
                    ImageSelectorEditor.this.value = new ByteArrayWrapper(byArray);
                    ImageSelectorEditor.this.imageLabel.setIcon(new ImageIcon(ImageSelectorEditor.this.value.getBuffer()));
                    GuiHelper.doLayoutHack((Component)ImageSelectorEditor.this.imageLabel, (boolean)true);
                }
                catch (Exception exception) {
                    ImageSelectorEditor.this.logger.error((Object)exception);
                    throw new RuntimeException(exception);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                ImageSelectorEditor.this.hasChanges = true;
                ImageSelectorEditor.this.checkEditorForChanges();
            }
        }
    }
}

