/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.awt.Color;
import java.lang.annotation.Annotation;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.chrono.TimeOnly;
import net.model3.guice.Injected;
import net.model3.util.TypeFactory;
import net.model3x.swing.RendererFactory;
import net.model3x.swing.beanprops.editors.BooleanEditor;
import net.model3x.swing.beanprops.editors.ColorCellRenderer;
import net.model3x.swing.beanprops.editors.ColorEditor;
import net.model3x.swing.beanprops.editors.ConverterFactoryEditorHandler;
import net.model3x.swing.beanprops.editors.DateTimeEditor;
import net.model3x.swing.beanprops.editors.Editor;
import net.model3x.swing.beanprops.editors.EditorAnnoEditorChooser;
import net.model3x.swing.beanprops.editors.EditorChooser;
import net.model3x.swing.beanprops.editors.EnumEditorChooser;
import net.model3x.swing.beanprops.editors.MetaTypeEditorChooser;
import net.model3x.swing.beanprops.editors.PropertyAttributeChooser;
import net.model3x.swing.beanprops.editors.TimeOnlyEditor;
import net.model3x.swing.datechooser.DateOnlyEditor;

@Singleton
public class EditorFactory
implements RendererFactory,
Injected {
    @Inject
    Injector _injector;
    @Inject
    TypeFactory<Editor<?>, IPropertyContext> _propertyFactory;
    @Inject
    TypeFactory<Editor<?>, Class<?>> _typeFactory;

    public void injectionCompleted() {
        this.registerDefaultChoosers();
    }

    public void registerDefaultChoosers() {
        this.registerChooser((EditorChooser)this._injector.getInstance(PropertyAttributeChooser.class));
        this.registerChooser((EditorChooser)this._injector.getInstance(EditorAnnoEditorChooser.class));
        this.registerChooser((EditorChooser)this._injector.getInstance(MetaTypeEditorChooser.class));
        this.registerChooser((EditorChooser)this._injector.getInstance(EnumEditorChooser.class));
        this.registerChooser((EditorChooser)this._injector.getInstance(ConverterFactoryEditorHandler.class));
        this.setEditorForType(DateOnly.class, DateOnlyEditor.class);
        this.setEditorForType(Color.class, ColorEditor.class);
        this.setEditorForType(DateTime.class, DateTimeEditor.class);
        this.setEditorForType(TimeOnly.class, TimeOnlyEditor.class);
        this.setEditorForType(Boolean.class, BooleanEditor.class);
    }

    public void registerChooser(final EditorChooser editorChooser) {
        this._propertyFactory.registerHandler(new TypeFactory.Handler<Editor<?>, IPropertyContext>(){

            public boolean canHandleSource(IPropertyContext iPropertyContext) {
                return editorChooser.canHandleProperty(iPropertyContext);
            }

            public Editor<?> createInstance(IPropertyContext iPropertyContext) {
                return editorChooser.createInstance(iPropertyContext);
            }
        });
        this._typeFactory.registerHandler(new TypeFactory.Handler<Editor<?>, Class<?>>(){

            public boolean canHandleSource(Class<?> clazz) {
                return editorChooser.canHandleType(clazz);
            }

            public Editor<?> createInstance(Class<?> clazz) {
                return editorChooser.createInstance(clazz);
            }
        });
    }

    public void setEditorForType(Class<?> clazz, final Class<?> clazz2) {
        this._typeFactory.setResolution(clazz, new TypeFactory.Handler<Editor<?>, Class<?>>(){

            public boolean canHandleSource(Class<?> clazz) {
                return false;
            }

            public Editor<?> createInstance(Class<?> clazz) {
                return (Editor)EditorFactory.this._injector.getInstance(clazz2);
            }
        });
    }

    @Override
    public TableCellEditor getTableCellEditor(Class<?> clazz) {
        return null;
    }

    @Override
    public TableCellRenderer getTableCellRenderer(Class<?> clazz) {
        if (clazz.equals(Color.class)) {
            return new ColorCellRenderer();
        }
        return null;
    }

    public Editor<?> getEditor(PropertyContextable propertyContextable) {
        return this.getEditorImpl(propertyContextable.getContext());
    }

    protected Editor<?> getEditorImpl(IPropertyContext iPropertyContext) {
        Editor editor = (Editor)this._propertyFactory.getInstance((Object)iPropertyContext);
        if (editor == null) {
            editor = (Editor)this._typeFactory.getInstance((Object)iPropertyContext.getType());
        }
        return editor;
    }

    <T extends Annotation> T getAnno(IPropertyContext iPropertyContext, Class<T> clazz) {
        Annotation annotation = iPropertyContext.getAnnotation(clazz);
        if (annotation == null) {
            Class clazz2 = iPropertyContext.getType();
            annotation = clazz2.getAnnotation(clazz);
        }
        return (T)annotation;
    }
}

