/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.model3x.swing.EntityComboBoxModel;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.beanprops.editors.AbstractEditor;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class DropDownEditor<T>
extends AbstractEditor<T, JComponent> {
    EntityComboBoxModel<T> _model = new EntityComboBoxModel();
    @Inject
    HStringProvider _stringProvider;

    public DropDownEditor(List<T> list) {
        this._model.setItems(list);
    }

    public DropDownEditor() {
    }

    @Override
    public T getValueFromWidget() {
        return this._model.getSelectedEntity();
    }

    @Override
    public void setValueInWidget(T t) {
        this._model.setSelectedEntity(t);
    }

    @Override
    public JComponent initWidget() {
        final JComboBox<T> jComboBox = new JComboBox<T>(this._model);
        AutoCompleteDecorator.decorate(jComboBox);
        JXLayer jXLayer = new JXLayer(jComboBox);
        jXLayer.setUI((LayerUI)new AbstractLayerUI<JComboBox>(){

            protected void processMouseEvent(MouseEvent mouseEvent, JXLayer<? extends JComboBox> jXLayer) {
                super.processMouseEvent(mouseEvent, jXLayer);
                if (mouseEvent.getID() == 500) {
                    jComboBox.showPopup();
                }
            }
        });
        return jXLayer;
    }

    public EntityComboBoxModel<T> getModel() {
        return this._model;
    }
}

