/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.chrono.TimeOnly;
import net.model3x.swing.M3Layout;
import net.model3x.swing.beanprops.editors.AbstractEditor;
import net.model3x.swing.beanprops.editors.TimeOnlyEditor;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;

public class DateTimeEditor
extends AbstractEditor<DateTime, JPanel> {
    TextFieldDateOnlyChooser _dateChooser = new TextFieldDateOnlyChooser();
    JTextField _time = new JTextField(6);

    @Override
    public JPanel initWidget() {
        JPanel jPanel = new JPanel(){

            @Override
            public int getBaseline(int n, int n2) {
                return DateTimeEditor.this._time.getBaseline(n, n2);
            }

            @Override
            public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
                return DateTimeEditor.this._time.getBaselineResizeBehavior();
            }
        };
        jPanel.setLayout((LayoutManager)new M3Layout("fill, ins 0"));
        jPanel.add((Component)this._dateChooser, "growx");
        jPanel.add(this._time);
        return jPanel;
    }

    @Override
    public DateTime getValueFromWidget() {
        DateOnly dateOnly = this._dateChooser.getValue();
        TimeOnly timeOnly = this.getTimeOnly();
        if (dateOnly == null || timeOnly == null) {
            return null;
        }
        return new DateTime(dateOnly, this.getTimeOnly());
    }

    TimeOnly getTimeOnly() {
        try {
            return TimeOnly.parse((String)this._time.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setValueInWidget(DateTime dateTime) {
        if (dateTime == null) {
            this._dateChooser.setValue(null);
            this._time.setText("");
        } else {
            this._dateChooser.setValue(dateTime.asDateOnly());
            this._time.setText(TimeOnlyEditor.dateFormatter.format(dateTime));
        }
    }
}

