/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import net.model3x.swing.beanprops.editors.AbstractEditor;
import net.model3x.swing.beanprops.editors.ColorCellRenderer;

public class ColorEditor
extends AbstractEditor<Color, ColorCellRenderer> {
    Color _color;

    @Override
    public Color getValueFromWidget() {
        return this._color;
    }

    @Override
    public ColorCellRenderer initWidget() {
        final ColorCellRenderer colorCellRenderer = new ColorCellRenderer();
        colorCellRenderer.setOpaque(true);
        colorCellRenderer.setHorizontalTextPosition(0);
        colorCellRenderer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (colorCellRenderer.isEnabled()) {
                    colorCellRenderer.requestFocus();
                    Color color = JColorChooser.showDialog(colorCellRenderer, "Choose Color", colorCellRenderer.getBackground());
                    if (color != null) {
                        ColorEditor.this._color = color;
                        colorCellRenderer.setColor(color);
                        ColorEditor.this.getFormBuilder().checkEditorForChanges(ColorEditor.this);
                    }
                }
            }
        });
        colorCellRenderer.setFocusable(true);
        return colorCellRenderer;
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
    }

    @Override
    public void setValueInWidget(Color color) {
        this._color = color;
        if (color == null) {
            this._color = Color.white;
        }
        ((ColorCellRenderer)this.getWidget()).setColor(this._color);
    }
}

