/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.awt.ItemSelectable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.lang.ObjectX;
import net.model3.lang.StringX;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.beanprops.EditorAnno;
import net.model3x.swing.beanprops.Required;
import net.model3x.swing.beanprops.editors.Editor;
import net.model3x.swing.beanprops.editors.EditorChooser;
import net.model3x.swing.beanprops.editors.MegaListener;
import net.model3x.swing.beanprops.editors.MegaListenerAction;
import net.model3x.swing.beanprops.form.FormBuilder;
import net.model3x.swing.beanprops.form.FormField;

public abstract class AbstractEditor<T, U extends JComponent>
implements Editor<T>,
EditorChooser {
    protected Logger logger = LoggerHelper.getLogger();
    private FormBuilder<Object> _formBuilder;
    private U _widget;
    private IPropertyContext _property;
    private MegaListener _megaListener = new MegaListener(this, new MegaListenerAction(){

        @Override
        public void performAction() {
            if (!((AbstractEditor)AbstractEditor.this)._megaListener._alreadyCheckingForChanges) {
                ((AbstractEditor)AbstractEditor.this)._megaListener._alreadyCheckingForChanges = true;
                try {
                    ((AbstractEditor)AbstractEditor.this)._megaListener._editor.checkEditorForChanges();
                }
                finally {
                    ((AbstractEditor)AbstractEditor.this)._megaListener._alreadyCheckingForChanges = false;
                }
            }
        }
    });
    private boolean _editable = true;
    private boolean _required = false;
    private T _originalValue;
    @Inject
    Injector _injector;

    @Override
    public void init(FormBuilder<?> formBuilder, IPropertyContext iPropertyContext) {
        this._formBuilder = formBuilder;
        this._property = iPropertyContext;
        this._widget = this.initWidget();
        this.wireUpListeners();
    }

    public abstract U initWidget();

    public U getWidget() {
        return this._widget;
    }

    @Override
    public IPropertyContext getProperty() {
        return this._property;
    }

    public Object getBean() {
        return this._formBuilder.getBean();
    }

    @Override
    public void populateWidget() {
        this.setValueInWidget(this._property.getValue(this.getBean()));
        this._originalValue = this.getValueFromWidget();
    }

    @Override
    public void populateBean() {
        if (this.isEditable()) {
            this._property.setValue(this.getBean(), this.getValueFromWidget());
        }
    }

    @Override
    public abstract T getValueFromWidget();

    public abstract void setValueInWidget(T var1);

    @Override
    public void setEditable(boolean bl) {
        this._editable = bl;
        ((JComponent)this.getWidget()).setEnabled(bl);
        GuiHelper.enableDescendants(this.getWidget(), (boolean)bl);
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setRequired(boolean bl) {
        this._required = bl;
    }

    @Override
    public boolean isRequired() {
        if (!this._required) {
            this._required = this.getProperty().getAnnotation(Required.class) != null;
        }
        return this._required;
    }

    public void wireUpListeners() {
        GuiHelper.visitComponentAndDescendants(this.getWidget(), (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                JComponent jComponent2;
                if (jComponent instanceof JTextComponent) {
                    jComponent2 = (JTextComponent)jComponent;
                    ((JTextComponent)jComponent2).getDocument().addDocumentListener(AbstractEditor.this._megaListener);
                }
                if (jComponent instanceof ItemSelectable) {
                    ((ItemSelectable)((Object)jComponent)).addItemListener(AbstractEditor.this._megaListener);
                }
                if (jComponent instanceof JList) {
                    jComponent2 = (JList)jComponent;
                    ((JList)jComponent2).getModel().addListDataListener(AbstractEditor.this._megaListener);
                }
            }
        });
    }

    @Override
    public boolean hasChanges() {
        return !ObjectX.equals(this.getValueFromWidget(), this._originalValue);
    }

    public T getOriginalValue() {
        return this._originalValue;
    }

    protected void checkEditorForChanges() {
        if (this._formBuilder.isInitialized()) {
            this._formBuilder.checkEditorForChanges(this);
            this.validate();
        }
    }

    public FormBuilder<Object> getFormBuilder() {
        return this._formBuilder;
    }

    public String toString() {
        String string = null;
        try {
            string = this.getBean().getClass().getName() + "$" + this.getProperty().getName();
        }
        catch (Exception exception) {
            this.logger.trace((Object)"toString() threw a NPE");
        }
        return string;
    }

    public void clearAllErrors() {
        this.getFormBuilder().clearAllErrorMessagesForField((PropertyContextable)this.getProperty());
    }

    public void clearErrorsForOwner(Object object) {
        this.getFormBuilder().clearErrorMessages((PropertyContextable)this.getProperty(), object);
    }

    public void addErrorMessage(Object object, String string) {
        this.getFormBuilder().addErrorMessage((PropertyContextable)this.getProperty(), object, string);
    }

    public FormField getFormField() {
        return this.getFormBuilder().getField(this.getProperty());
    }

    public int getColumnCount(int n) {
        EditorAnno editorAnno = (EditorAnno)this.getProperty().getAnnotation(EditorAnno.class);
        if (editorAnno != null && editorAnno.columnCount() > 0) {
            return editorAnno.columnCount();
        }
        return n;
    }

    @Override
    public void validate() {
        T t;
        FormField formField = this.getFormField();
        this.getFormBuilder().clearErrorMessages((PropertyContextable)this.getProperty(), this);
        if (this.isRequired() && ((t = this.getValueFromWidget()) == null || StringX.isBlank((String)t.toString()))) {
            this.getFormBuilder().addErrorMessage((PropertyContextable)this.getProperty(), this, this.getProperty().getDisplayName() + " is required");
        }
    }

    @Override
    public boolean canHandleProperty(IPropertyContext iPropertyContext) {
        return false;
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public Editor<?> createInstance(Class<?> clazz) {
        return this.createInstance();
    }

    private Editor<?> createInstance() {
        return (Editor)this._injector.getInstance(this.getClass());
    }

    @Override
    public Editor<?> createInstance(IPropertyContext iPropertyContext) {
        return this.createInstance();
    }

    @Override
    public void addChangeListener(final MegaListener megaListener) {
        GuiHelper.visitComponentAndDescendants(this.getWidget(), (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                JComponent jComponent2;
                if (jComponent instanceof JTextComponent) {
                    jComponent2 = (JTextComponent)jComponent;
                    ((JTextComponent)jComponent2).getDocument().addDocumentListener(megaListener);
                }
                if (jComponent instanceof ItemSelectable) {
                    ((ItemSelectable)((Object)jComponent)).addItemListener(megaListener);
                }
                if (jComponent instanceof JList) {
                    jComponent2 = (JList)jComponent;
                    ((JList)jComponent2).getModel().addListDataListener(megaListener);
                }
            }
        });
    }
}

