/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops;

import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Size;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Layout;
import net.model3x.swing.beanprops.form.FormBuilder;
import net.model3x.swing.uistate.FrameStateMarshaller;

public class FormPopup<T> {
    FormBuilder<T> _formBuilder;
    private JFrame _frame;
    private String _title;
    private Size _size;
    private String _uiStateName;
    Class<T> _class;
    Point _location;

    public FormPopup(String string, String string2, Class<T> clazz) {
        this._title = string;
        this._uiStateName = string2;
        this._class = clazz;
    }

    public void close() {
        if (this._frame != null) {
            this._frame.setVisible(false);
        }
    }

    public FormBuilder<T> getFormBuilder() {
        if (this._formBuilder == null) {
            this._formBuilder = new FormBuilder(this._class);
        }
        return this._formBuilder;
    }

    public void show(Point point) {
        this.getFormBuilder().enableButtons();
        this.getFormBuilder().getSaveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormPopup.this.close();
            }
        });
        this.getFormBuilder().getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormPopup.this.close();
            }
        });
        JLayeredPane jLayeredPane = this._formBuilder.getForm();
        this._frame = new JFrame(this._title);
        this._frame.setLayout((LayoutManager)new M3Layout());
        this._frame.add(jLayeredPane);
        if (this.getSize() != null) {
            this._frame.setSize(this.getSize().asDimension());
        } else {
            this._frame.pack();
        }
        if (this._location != null) {
            this._frame.setLocation(this._location);
        }
        this._frame.setName(this._uiStateName);
        ((FrameStateMarshaller)DependencyInjector.get().getInstance(FrameStateMarshaller.class)).attach(this._frame);
        GuiHelper.positionWindowFullyOnScreen((Window)this._frame, (Point)point, (GuiHelper.LocationType)GuiHelper.LocationType.Center);
        this._frame.setVisible(true);
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public void setLocation(Point point) {
        this._location = point;
    }

    public void setSize(Size size) {
        this._size = size;
    }

    public Size getSize() {
        return this._size;
    }
}

