/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.model3.lang.ClassX;
import net.model3.lang.Visitor;
import net.model3.swing.EventManager;
import net.model3x.swing.BeanListener;
import net.model3x.swing.ComponentFactory;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Layout;
import net.model3x.swing.beanprops.BeanViewsFactory;
import net.model3x.swing.beanprops.editors.AbstractEditor;

public class EntitySelectionPopupEditor<T>
extends AbstractEditor<T, JPanel> {
    T _selectedValue;
    JLabel _label = new JLabel();
    JButton _select = new JButton(new ImageIcon(ClassX.getResource((String)"find-16.png")));
    EventManager<BeanListener<T>> _eventManager = EventManager.create();
    @Inject
    HStringProvider _stringProvider;
    @Inject
    BeanViewsFactory _beanViewsFactory;
    @Inject
    ComponentFactory _componentFactory;

    public EntitySelectionPopupEditor() {
        this._select.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public T getValueFromWidget() {
        return this._selectedValue;
    }

    public void addSetValueListener(BeanListener<T> beanListener) {
        this._eventManager.addListener(beanListener);
    }

    @Override
    public void setValueInWidget(T t) {
        this._selectedValue = t;
        this._label.setText(this._stringProvider.toString(t));
        this._eventManager.safeDispatch(new Visitor<BeanListener<T>>(){

            public void visit(BeanListener<T> beanListener) {
                beanListener.beanEvent(EntitySelectionPopupEditor.this._selectedValue);
            }
        });
    }

    @Override
    public JPanel initWidget() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new M3Layout("fill, ins 0"));
        jPanel.add((Component)this._label, "grow, left");
        jPanel.add((Component)this._select, "right");
        IBeanContext iBeanContext = BeanContainer.get().getContext(this.getProperty().getType());
        this._label.setText("No " + iBeanContext.getDisplayName() + " Selected");
        this._label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EntitySelectionPopupEditor.this.showSelectionPopup();
            }
        });
        this._select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitySelectionPopupEditor.this.showSelectionPopup();
            }
        });
        return jPanel;
    }

    String getPopupId() {
        return this.getProperty().toString();
    }

    public void showSelectionPopup() {
        this._componentFactory.showEntitySelectionPopup((Component)this.getWidget(), this.getProperty(), (BeanListener<?>)new BeanListener<T>(){

            public void beanEvent(T t) {
                EntitySelectionPopupEditor.this.setValueInWidget(t);
            }
        });
    }

    public JLabel getLabel() {
        return this._label;
    }
}

