/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import net.model3.chrono.TimeOnly;
import net.model3.chrono.TimeRange;
import net.model3.chrono.TimeRangeIterable;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class TimeRangeWidget
extends JComponent {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 1L;
    Dimension _markerSize = new Dimension(10, 20);
    Integer _startPosition;
    Integer _endPosition;
    List<TimeSpan> timespans = new ArrayList<TimeSpan>();
    TimeSpan timespan = new TimeSpan();
    TimeRange _componentRange = new TimeRange(new TimeOnly("6:00am"), new TimeOnly("8:00pm"));
    TimeDuration _increment = new TimeDuration("15 minutes");
    double _incrementSize = 0.01;
    int _ticksPerHour = 4;
    boolean pressBeganWithinStart = false;
    boolean pressBeganWithinEnd = false;
    boolean ignoreDragEvents = false;
    boolean mapIsInitialized = false;
    boolean unpaintedTimespansToDraw = false;
    boolean needToFireValuesChanged = false;
    NavigableMap<Integer, String> positionToTime = new TreeMap<Integer, String>();
    Color activeConnectorColor = Color.red;
    Color inactiveConnectorColor = Color.LIGHT_GRAY;
    Color activeMarkerFillColor = Color.BLACK;
    Color inactiveMarkerFillColor = Color.GRAY;
    Color activeMarkerTextColor = Color.BLACK;
    Color inactiveMarkerTextColor = Color.GRAY;
    ActionListener _valuesChangedListener;

    public TimeRangeWidget() {
        this.init();
    }

    public TimeRangeWidget(ActionListener actionListener) {
        this._valuesChangedListener = actionListener;
        this.init();
    }

    public TimeRangeWidget(TimeRange timeRange, TimeDuration timeDuration) {
        this._componentRange = timeRange;
        this._increment = timeDuration;
        this.init();
    }

    public TimeRangeWidget(TimeRange timeRange, TimeDuration timeDuration, ActionListener actionListener) {
        this._componentRange = timeRange;
        this._increment = timeDuration;
        this._valuesChangedListener = actionListener;
        this.init();
    }

    @Override
    public boolean isFocusable() {
        return super.isFocusable();
    }

    private void init() {
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                logger.trace((Object)"Focus gained on TimeRangeWidget");
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                logger.trace((Object)"Focus lost on TimeRangeWidget");
            }
        });
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                logger.trace((Object)("new size = " + TimeRangeWidget.this.getWidth()));
                logger.trace((Object)"redo the map... we've changed our size");
                TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
                for (Map.Entry object : TimeRangeWidget.this.positionToTime.entrySet()) {
                    treeMap.put((Integer)object.getKey(), ((String)object.getValue()).toString());
                }
                TimeRangeWidget.this.initPositionToTimeMap();
                TimeRangeWidget.this.timespan = new TimeSpan();
                TimeRangeWidget.this._startPosition = null;
                TimeRangeWidget.this._endPosition = null;
                for (TimeSpan timeSpan : TimeRangeWidget.this.timespans) {
                    timeSpan.redraw((Graphics2D)componentEvent.getComponent().getGraphics(), treeMap);
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TimeRangeWidget.this.grabFocus();
                if (Math.abs((double)(TimeRangeWidget.this.getHeight() / 2) - mouseEvent.getPoint().getY()) > (double)(TimeRangeWidget.this._markerSize.height / 2)) {
                    logger.trace((Object)"must click near the line or on a marker");
                    TimeRangeWidget.this.ignoreDragEvents = true;
                } else if (mouseEvent.getButton() == 3) {
                    TimeRangeWidget.this.ignoreDragEvents = true;
                } else {
                    TimeRangeWidget.this.timespan = TimeRangeWidget.this.getTimeSpanWithConnectionContainingPoint(TimeRangeWidget.this.timespans, mouseEvent.getPoint());
                    if (TimeRangeWidget.this.timespan != null) {
                        logger.trace((Object)"nothing should happen, click was on connector. must click on markers to resize");
                        TimeRangeWidget.this.ignoreDragEvents = true;
                    } else {
                        TimeRangeWidget.this.timespan = TimeRangeWidget.this.getTimeSpanWithStartMarkerContainingPoint(TimeRangeWidget.this.timespans, mouseEvent.getPoint());
                        if (TimeRangeWidget.this.timespan != null) {
                            TimeRangeWidget.this.pressBeganWithinStart = true;
                            TimeRangeWidget.this._startPosition = mouseEvent.getX();
                            logger.trace((Object)"inside the start marker");
                        } else {
                            TimeRangeWidget.this.timespan = TimeRangeWidget.this.getTimeSpanWithEndMarkerContainingPoint(TimeRangeWidget.this.timespans, mouseEvent.getPoint());
                            if (TimeRangeWidget.this.timespan != null) {
                                TimeRangeWidget.this.pressBeganWithinEnd = true;
                                TimeRangeWidget.this._endPosition = mouseEvent.getX();
                                logger.trace((Object)"inside the end marker");
                            } else {
                                TimeRangeWidget.this.timespan = new TimeSpan();
                                TimeRangeWidget.this.timespans.add(TimeRangeWidget.this.timespan);
                                Map.Entry<Integer, String> entry = null;
                                Map.Entry<Integer, String> entry2 = TimeRangeWidget.this.positionToTime.floorEntry(mouseEvent.getX());
                                Map.Entry<Integer, String> entry3 = TimeRangeWidget.this.positionToTime.ceilingEntry(mouseEvent.getX());
                                entry = entry2 != null && entry3 != null ? (mouseEvent.getX() - entry2.getKey() <= entry3.getKey() - mouseEvent.getX() ? entry2 : entry3) : (entry2 != null ? entry2 : entry3);
                                if (entry != null) {
                                    TimeRangeWidget.this._startPosition = entry.getKey();
                                    entry = TimeRangeWidget.this.positionToTime.higherEntry(mouseEvent.getX());
                                    if (entry != null && (entry = TimeRangeWidget.this.positionToTime.higherEntry(entry.getKey())) != null) {
                                        TimeRangeWidget.this._endPosition = entry.getKey();
                                        logger.trace((Object)("new starting time span " + TimeRangeWidget.this._startPosition));
                                        TimeRangeWidget.this.repaint();
                                    }
                                    TimeRangeWidget.this.needToFireValuesChanged = true;
                                }
                            }
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                TimeRangeWidget.this.ignoreDragEvents = false;
                if (TimeRangeWidget.this.pressBeganWithinStart && TimeRangeWidget.this.timespan != null && TimeRangeWidget.this.timespan.getStartMarker() != null) {
                    if (TimeRangeWidget.this.positionToTime.containsKey(TimeRangeWidget.this._startPosition)) {
                        logger.trace((Object)"start already snapped to grid");
                    } else {
                        int n = (int)TimeRangeWidget.this.timespan.getStartMarker().getCenterX();
                        logger.trace((Object)("snap start to grid from center position " + n));
                        Map.Entry<Integer, String> entry = TimeRangeWidget.this.positionToTime.floorEntry(n);
                        Map.Entry<Integer, String> entry2 = TimeRangeWidget.this.positionToTime.ceilingEntry(n);
                        if (entry != null) {
                            logger.trace((Object)("to floor (" + entry.getKey() + ") = " + (n - entry.getKey()) + " -- to ceiling (" + entry2.getKey() + ") = " + (entry2.getKey() - n)));
                        }
                        TimeRangeWidget.this._startPosition = entry != null && entry2 != null ? (n - entry.getKey() <= entry2.getKey() - n ? entry.getKey() : entry2.getKey()) : (entry != null ? entry.getKey() : entry2.getKey());
                        TimeRangeWidget.this.repaint();
                    }
                    TimeRangeWidget.this.needToFireValuesChanged = true;
                } else if (TimeRangeWidget.this.pressBeganWithinEnd && TimeRangeWidget.this.timespan != null && TimeRangeWidget.this.timespan.getEndMarker() != null) {
                    if (TimeRangeWidget.this.positionToTime.containsKey(TimeRangeWidget.this._endPosition)) {
                        logger.trace((Object)"end already snapped to grid");
                    } else {
                        int n = (int)TimeRangeWidget.this.timespan.getEndMarker().getCenterX();
                        logger.trace((Object)("snap end to grid from center position " + n));
                        Map.Entry<Integer, String> entry = TimeRangeWidget.this.positionToTime.floorEntry(n);
                        Map.Entry<Integer, String> entry3 = TimeRangeWidget.this.positionToTime.ceilingEntry(n);
                        TimeRangeWidget.this._endPosition = entry != null && entry3 != null ? (n - entry.getKey() <= entry3.getKey() - n ? entry.getKey() : entry3.getKey()) : (entry != null ? entry.getKey() : entry3.getKey());
                        TimeRangeWidget.this.repaint();
                    }
                    TimeRangeWidget.this.needToFireValuesChanged = true;
                }
                TimeRangeWidget.this.pressBeganWithinStart = false;
                TimeRangeWidget.this.pressBeganWithinEnd = false;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (TimeRangeWidget.this.ignoreDragEvents) {
                    return;
                }
                if (TimeRangeWidget.this.pressBeganWithinStart) {
                    TimeRangeWidget.this._startPosition = mouseEvent.getX();
                    TimeRangeWidget.this._endPosition = (int)TimeRangeWidget.this.timespan.getEndMarker().getCenterX();
                    logger.trace((Object)"move start");
                    TimeRangeWidget.this.repaint();
                } else if (TimeRangeWidget.this.pressBeganWithinEnd) {
                    TimeRangeWidget.this._startPosition = (int)TimeRangeWidget.this.timespan.getStartMarker().getCenterX();
                    TimeRangeWidget.this._endPosition = mouseEvent.getX();
                    logger.trace((Object)"move end");
                    TimeRangeWidget.this.repaint();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addComponentListener(componentAdapter);
        TimeRange timeRange = new TimeRange(new TimeOnly("6:00am"), new TimeOnly("7:00am"));
        TimeRangeIterable timeRangeIterable = timeRange.iter(this._increment, false);
        this._ticksPerHour = timeRangeIterable.getCount();
    }

    public Color getActiveConnectorColor() {
        return this.activeConnectorColor;
    }

    public void setActiveConnectorColor(Color color) {
        this.activeConnectorColor = color;
        this.repaint();
    }

    public Color getInactiveConnectorColor() {
        return this.inactiveConnectorColor;
    }

    public void setInactiveConnectorColor(Color color) {
        this.inactiveConnectorColor = color;
        this.repaint();
    }

    public Color getActiveMarkerFillColor() {
        return this.activeMarkerFillColor;
    }

    public void setActiveMarkerFillColor(Color color) {
        this.activeMarkerFillColor = color;
        this.repaint();
    }

    public Color getInactiveMarkerFillColor() {
        return this.inactiveMarkerFillColor;
    }

    public void setInactiveMarkerFillColor(Color color) {
        this.inactiveMarkerFillColor = color;
        this.repaint();
    }

    public Color getActiveMarkerTextColor() {
        return this.activeMarkerTextColor;
    }

    public void setActiveMarkerTextColor(Color color) {
        this.activeMarkerTextColor = color;
        this.repaint();
    }

    public Color getInactiveMarkerTextColor() {
        return this.inactiveMarkerTextColor;
    }

    public void setInactiveMarkerTextColor(Color color) {
        this.inactiveMarkerTextColor = color;
        this.repaint();
    }

    public List<TimeRange> getValue() {
        ArrayList<TimeRange> arrayList = new ArrayList<TimeRange>();
        for (TimeSpan timeSpan : this.timespans) {
            String string = this.resolveTimeFromPosition((int)timeSpan.getStartMarker().getMaxX());
            logger.trace((Object)("Got start value of " + timeSpan.getStartMarker().getMaxX() + " as " + string));
            String string2 = this.resolveTimeFromPosition((int)timeSpan.getEndMarker().getMaxX());
            logger.trace((Object)("Got end value of " + timeSpan.getEndMarker().getMaxX() + " as " + string2));
            if ("Noon".equals(string)) {
                string = "12:00pm";
            }
            if ("Noon".equals(string2)) {
                string2 = "12:00pm";
            }
            if ("Midnight".equals(string)) {
                string = "12:00am";
            }
            if ("Midnight".equals(string2)) {
                string2 = "12:00am";
            }
            TimeRange timeRange = new TimeRange(new TimeOnly(string), new TimeOnly(string2));
            arrayList.add(timeRange);
        }
        return arrayList;
    }

    public void setValue(List<TimeRange> list) {
        this.timespans.clear();
        this._startPosition = null;
        this._endPosition = null;
        this.timespan = new TimeSpan();
        if (list != null && !list.isEmpty()) {
            logger.trace((Object)("Set the value: " + list.size() + " timeranges -- width: " + this.getWidth()));
            if (this.getWidth() == 0) {
                this.unpaintedTimespansToDraw = true;
            }
            for (TimeRange timeRange : list) {
                TimeSpan timeSpan = new TimeSpan();
                String string = timeRange.getStart().getHourAs12Hour() + "";
                String string2 = timeRange.getStart().getMinutes() == 0 ? "00" : "" + timeRange.getStart().getMinutes();
                String string3 = string + ":" + string2 + (timeRange.getStart().getHour() < 12 ? "am" : "pm");
                string = timeRange.getEnd().getHourAs12Hour() + "";
                string2 = timeRange.getEnd().getMinutes() == 0 ? "00" : "" + timeRange.getEnd().getMinutes();
                String string4 = string + ":" + string2 + (timeRange.getEnd().getHour() < 12 ? "am" : "pm");
                if (timeRange.getStart().getHour() == 12) {
                    string3 = "Noon";
                }
                if (timeRange.getEnd().getHour() == 12) {
                    string4 = "Noon";
                }
                if (timeRange.getStart().getHour() == 24 || timeRange.getStart().getHour() == 0) {
                    string3 = "Midnight";
                }
                if (timeRange.getEnd().getHour() == 24 || timeRange.getEnd().getHour() == 0) {
                    string4 = "Midnight";
                }
                if (this.unpaintedTimespansToDraw) {
                    timeSpan.setStartTime(string3);
                    timeSpan.setEndTime(string4);
                    this.timespans.add(timeSpan);
                    continue;
                }
                Integer n = this.resolvePositionFromTime(string3);
                Integer n2 = this.resolvePositionFromTime(string4);
                if (n == null || n2 == null) continue;
                logger.trace((Object)"Draw the timespans");
                timeSpan.setStartMarker(this.drawMarker((Graphics2D)this.getGraphics(), n));
                timeSpan.setEndMarker(this.drawMarker((Graphics2D)this.getGraphics(), n2));
                timeSpan.setConnection(this.connectMarkers((Graphics2D)this.getGraphics(), n, n2));
                timeSpan.reset((Graphics2D)this.getGraphics());
                this.timespans.add(timeSpan);
            }
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.mapIsInitialized) {
            this.initPositionToTimeMap();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics.setColor(this.getBackground());
        graphics.drawRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        this.paintTimeLine(graphics);
        if (this._startPosition == null && this._endPosition == null) {
            this.timespan = new TimeSpan();
        } else if (this.timespan.getEndMarker() != null && this.timespan.getStartMarker() != null && this.timespan.endMarker.getMinX() < this.timespan.getStartMarker().getMaxX()) {
            logger.trace((Object)"intersection occured - delete range");
            this.timespans.remove(this.timespan);
            this.timespan = new TimeSpan();
            this.ignoreDragEvents = true;
            this.needToFireValuesChanged = true;
        } else if (this.pressBeganWithinStart && this.timespan.getStartMarker() != null && this.isStartMarkerOverlapping(this.timespans, this.timespan)) {
            logger.trace((Object)"our beginning is hitting the end of another");
            this.timespan.setStartMarker(this.drawMarker(graphics2D, this._startPosition));
            this.timespan.setEndMarker(this.drawMarker(graphics2D, this._endPosition));
            this.timespan.setConnection(this.connectMarkers(graphics2D, this._startPosition, this._endPosition));
            this.timespan.reset(graphics2D);
        } else if (this.pressBeganWithinEnd && this.timespan.getEndMarker() != null && this.isEndMarkerOverlapping(this.timespans, this.timespan)) {
            logger.trace((Object)"our end is hitting the beginning of another");
            this.timespan.setStartMarker(this.drawMarker(graphics2D, this._startPosition));
            this.timespan.setEndMarker(this.drawMarker(graphics2D, this._endPosition));
            this.timespan.setConnection(this.connectMarkers(graphics2D, this._startPosition, this._endPosition));
            this.timespan.reset(graphics2D);
        } else if (this.timespan.getStartMarker() == null || this.timespan.getEndMarker() == null || !this.timespan.getStartMarker().intersects(this.timespan.getEndMarker())) {
            logger.trace((Object)"no intersection");
            this.timespan.setStartMarker(this.drawMarker(graphics2D, this._startPosition));
            this.timespan.setEndMarker(this.drawMarker(graphics2D, this._endPosition));
            this.timespan.setConnection(this.connectMarkers(graphics2D, this._startPosition, this._endPosition));
            this.timespan.reset(graphics2D);
        } else {
            logger.trace((Object)"**********************CORNER CASE******************************");
        }
        for (TimeSpan timeSpan : this.timespans) {
            if (timeSpan.equals(this.timespan)) continue;
            timeSpan.redraw(graphics2D, null);
        }
        graphics2D.setPaint(paint);
        if (this.needToFireValuesChanged) {
            if (this._valuesChangedListener != null) {
                this._valuesChangedListener.actionPerformed(null);
            }
            this.needToFireValuesChanged = false;
        }
    }

    private Rectangle drawMarker(Graphics2D graphics2D, Integer n) {
        Rectangle rectangle = null;
        if (n != null) {
            int n2 = this.getHeight() / 2 - this._markerSize.height / 2;
            int n3 = n - this._markerSize.width / 2;
            if (n3 > (Integer)this.positionToTime.lastKey()) {
                n3 = (Integer)this.positionToTime.lastKey() - this._markerSize.width / 2;
            } else if (n3 < (Integer)this.positionToTime.firstKey()) {
                n3 = (Integer)this.positionToTime.firstKey() - this._markerSize.width / 2;
            }
            graphics2D.setColor(this.activeMarkerFillColor);
            Rectangle rectangle2 = new Rectangle(n3, n2, this._markerSize.width, this._markerSize.height);
            graphics2D.fill(rectangle2);
            rectangle = rectangle2;
            String string = this.resolveTimeFromPosition(n);
            logger.trace((Object)("resolving " + n + " as time " + string));
            if (string == null || string.length() == 0) {
                string = this.positionToTime.firstEntry().getValue();
            }
            graphics2D.setColor(this.activeMarkerTextColor);
            graphics2D.drawString(string, n3 - this._markerSize.width, n2 - 20);
            graphics2D.setColor(Color.black);
        }
        return rectangle;
    }

    private Rectangle connectMarkers(Graphics2D graphics2D, Integer n, Integer n2) {
        Rectangle rectangle = null;
        if (n != null && n2 != null && n < n2) {
            int n3 = n + this._markerSize.width / 2;
            if (n3 < (Integer)this.positionToTime.firstKey() + this._markerSize.width / 2) {
                n3 = (Integer)this.positionToTime.firstKey() + this._markerSize.width / 2;
            }
            int n4 = this.getHeight() / 2 - this._markerSize.height / 2 - 2;
            int n5 = n2 - this._markerSize.width / 2 - n3;
            if (n3 + n5 > (Integer)this.positionToTime.lastKey() - this._markerSize.width) {
                n5 = (Integer)this.positionToTime.lastKey() - n3 - this._markerSize.width / 2;
            }
            Rectangle rectangle2 = new Rectangle(n3, n4 + 5, n5, this._markerSize.height - 5);
            graphics2D.setColor(this.activeConnectorColor);
            graphics2D.fill(rectangle2);
            rectangle = rectangle2;
        }
        return rectangle;
    }

    private String resolveTimeFromPosition(Integer n) {
        String string = "";
        if (n != null) {
            logger.trace((Object)("Reconciling position = " + n));
            Map.Entry<Integer, String> entry = this.positionToTime.floorEntry(n);
            Map.Entry<Integer, String> entry2 = this.positionToTime.ceilingEntry(n);
            string = entry != null && entry2 != null ? (n - entry.getKey() <= entry2.getKey() - n ? entry.getValue() : entry2.getValue()) : (entry != null ? entry.getValue() : entry2.getValue());
        }
        return string;
    }

    private Integer resolvePositionFromTime(String string) {
        Integer n = null;
        if (string != null && string.length() > 0) {
            for (Map.Entry entry : this.positionToTime.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                n = (Integer)entry.getKey();
                break;
            }
        }
        return n;
    }

    private void initPositionToTimeMap() {
        this.positionToTime.clear();
        TimeRangeIterable timeRangeIterable = this._componentRange.iter(this._increment, true);
        Iterator iterator = timeRangeIterable.iterator();
        int n = timeRangeIterable.getCount();
        this._incrementSize = ((double)(this.getWidth() - 40) - 20.0) / (double)(n - 1);
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = (this.getWidth() - 40) * n2 / n + 20;
            TimeOnly timeOnly = (TimeOnly)iterator.next();
            String string = timeOnly.getMinutes() + "";
            if (string.length() == 1) {
                string = string + "0";
            }
            String string2 = null;
            int n4 = timeOnly.getHour();
            string2 = n4 == 0 && "00".equals(string) ? "Midnight" : (n4 == 12 && "00".equals(string) ? "Noon" : (n4 == 12 ? n4 + ":" + string + "pm" : (n4 >= 12 ? (n4 -= 12) + ":" + string + "pm" : n4 + ":" + string + "am")));
            this.positionToTime.put(n3, string2);
            ++n2;
        }
        this.mapIsInitialized = true;
    }

    private void paintTimeLine(Graphics graphics) {
        TimeRangeIterable timeRangeIterable = this._componentRange.iter(this._increment, true);
        int n = timeRangeIterable.getCount();
        List list = timeRangeIterable.getTimes();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.getHeight() / 2;
        graphics.drawLine(10, n2, this.getWidth(), n2);
        int n3 = n2 + 10;
        int n4 = n2 - 10;
        for (int i = 0; i < n; ++i) {
            int n5 = (this.getWidth() - 40) * i / n + 20;
            String string = null;
            if (i % (this._ticksPerHour * 2) == 0) {
                graphics.drawLine(n5, n3, n5, n4);
                int n6 = ((TimeOnly)list.get(i)).getHour();
                string = n6 == 0 ? "Midnight" : (n6 == 12 ? "Noon" : (n6 > 12 ? (n6 -= 12) + "pm" : n6 + "am"));
                int n7 = fontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n5 - n7, n2 + 35);
                continue;
            }
            if (i % this._ticksPerHour == 0) {
                graphics.drawLine(n5, n3, n5, n4);
                continue;
            }
            graphics.drawLine(n5, n3 - 3, n5, n4 + 3);
        }
    }

    private TimeSpan getTimeSpanWithConnectionContainingPoint(List<TimeSpan> list, Point point) {
        TimeSpan timeSpan = null;
        if (list != null && !list.isEmpty()) {
            for (TimeSpan timeSpan2 : list) {
                if (timeSpan2.getConnection() == null || !timeSpan2.getConnection().contains(point)) continue;
                timeSpan = timeSpan2;
                break;
            }
        }
        return timeSpan;
    }

    private TimeSpan getTimeSpanWithStartMarkerContainingPoint(List<TimeSpan> list, Point point) {
        TimeSpan timeSpan = null;
        if (list != null && !list.isEmpty()) {
            for (TimeSpan timeSpan2 : list) {
                if (timeSpan2.getStartMarker() == null || !timeSpan2.getStartMarker().contains(point)) continue;
                timeSpan = timeSpan2;
                break;
            }
        }
        return timeSpan;
    }

    private TimeSpan getTimeSpanWithEndMarkerContainingPoint(List<TimeSpan> list, Point point) {
        TimeSpan timeSpan = null;
        if (list != null && !list.isEmpty()) {
            for (TimeSpan timeSpan2 : list) {
                if (timeSpan2.getEndMarker() == null || !timeSpan2.getEndMarker().contains(point)) continue;
                timeSpan = timeSpan2;
                break;
            }
        }
        return timeSpan;
    }

    private boolean isStartMarkerOverlapping(List<TimeSpan> list, TimeSpan timeSpan) {
        TimeSpan timeSpan2 = null;
        if (list != null && !list.isEmpty()) {
            double d = 0.0;
            for (TimeSpan timeSpan3 : list) {
                if (timeSpan3.equals(timeSpan)) continue;
                double d2 = timeSpan3.getEndMarker() != null ? timeSpan3.getEndMarker().getMaxX() + this._incrementSize : Double.MAX_VALUE;
                double d3 = this._startPosition.intValue();
                if (!(timeSpan.getEndMarker().getMinX() > d2) || !(d3 < d2)) continue;
                double d4 = timeSpan.getEndMarker().getMaxX() - timeSpan3.getEndMarker().getMaxX();
                if (timeSpan2 != null && !(d4 < d)) continue;
                timeSpan2 = timeSpan3;
                d = d4;
            }
            if (timeSpan2 != null) {
                Map.Entry<Integer, String> entry = this.positionToTime.lowerEntry((int)(timeSpan2.getEndMarker().getMaxX() + this._incrementSize));
                this._startPosition = (Integer)entry.getKey();
            }
        }
        return timeSpan2 != null;
    }

    private boolean isEndMarkerOverlapping(List<TimeSpan> list, TimeSpan timeSpan) {
        TimeSpan timeSpan2 = null;
        if (list != null && !list.isEmpty()) {
            double d = 0.0;
            for (TimeSpan timeSpan3 : list) {
                if (timeSpan3.equals(timeSpan)) continue;
                double d2 = timeSpan3.getStartMarker() != null ? timeSpan3.getStartMarker().getMinX() - this._incrementSize : Double.MIN_VALUE;
                double d3 = this._endPosition.intValue();
                if (!(timeSpan.getStartMarker().getMaxX() < d2) || !(d3 > d2)) continue;
                double d4 = timeSpan3.getStartMarker().getMinX() - timeSpan.getStartMarker().getMinX();
                if (timeSpan2 != null && !(d4 < d)) continue;
                timeSpan2 = timeSpan3;
                d = d4;
            }
            if (timeSpan2 != null) {
                Map.Entry<Integer, String> entry = this.positionToTime.higherEntry((int)(timeSpan2.getStartMarker().getMinX() - this._incrementSize));
                this._endPosition = (Integer)entry.getKey();
            }
        }
        return timeSpan2 != null;
    }

    private class TimeSpan {
        Rectangle startMarker;
        Rectangle endMarker;
        Rectangle connection;
        Rectangle container;
        String startTime;
        String endTime;

        private TimeSpan() {
        }

        public Rectangle getConnection() {
            return this.connection;
        }

        public void setConnection(Rectangle rectangle) {
            this.connection = rectangle;
        }

        public Rectangle getContainer() {
            return this.container;
        }

        public void setContainer(Rectangle rectangle) {
            this.container = rectangle;
        }

        public Rectangle getEndMarker() {
            return this.endMarker;
        }

        public void setEndMarker(Rectangle rectangle) {
            this.endMarker = rectangle;
        }

        public Rectangle getStartMarker() {
            return this.startMarker;
        }

        public void setStartMarker(Rectangle rectangle) {
            this.startMarker = rectangle;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String string) {
            this.startTime = string;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String string) {
            this.endTime = string;
        }

        public void reset(Graphics2D graphics2D) {
            this.container = new Rectangle();
            if (this.startMarker != null && this.connection != null && this.endMarker != null) {
                Rectangle.union(this.startMarker, this.connection, this.container);
                Rectangle.union(this.container, this.endMarker, this.container);
            }
        }

        public void redraw(Graphics2D graphics2D, NavigableMap<Integer, String> navigableMap) {
            Integer n;
            Object object;
            int n2 = TimeRangeWidget.this.getHeight() / 2 - TimeRangeWidget.this._markerSize.height / 2;
            int n3 = TimeRangeWidget.this.getHeight() / 2 - TimeRangeWidget.this._markerSize.height / 2 - 30;
            graphics2D.setColor(Color.BLACK);
            if (this.startMarker != null) {
                object = null;
                if (navigableMap != null) {
                    object = (String)navigableMap.get((int)this.startMarker.getCenterX());
                    n = TimeRangeWidget.this.resolvePositionFromTime((String)object);
                    if (n != null) {
                        this.startMarker.setLocation(n - TimeRangeWidget.this._markerSize.width / 2, n2);
                    }
                } else {
                    graphics2D.setColor(TimeRangeWidget.this.inactiveMarkerFillColor);
                    graphics2D.fill(this.startMarker);
                    int n4 = (int)this.startMarker.getCenterX();
                    object = TimeRangeWidget.this.resolveTimeFromPosition(n4);
                }
                if (object == null || ((String)object).length() == 0) {
                    object = navigableMap.firstEntry().getValue();
                }
                graphics2D.drawString((String)object, this.startMarker.x, n3);
            } else if (this.startTime != null && this.startTime.length() > 0) {
                object = TimeRangeWidget.this.resolvePositionFromTime(this.startTime);
                this.startMarker = TimeRangeWidget.this.drawMarker(graphics2D, (Integer)object);
            }
            if (this.endMarker != null) {
                object = null;
                if (navigableMap != null) {
                    object = (String)navigableMap.get((int)this.endMarker.getCenterX());
                    n = TimeRangeWidget.this.resolvePositionFromTime((String)object);
                    if (n != null) {
                        this.endMarker.setLocation(n - TimeRangeWidget.this._markerSize.width / 2, n2);
                    }
                } else {
                    graphics2D.setColor(TimeRangeWidget.this.inactiveMarkerFillColor);
                    graphics2D.fill(this.endMarker);
                    int n5 = (int)this.endMarker.getCenterX();
                    object = TimeRangeWidget.this.resolveTimeFromPosition(n5);
                }
                if (object == null || ((String)object).length() == 0) {
                    object = navigableMap.firstEntry().getValue();
                }
                graphics2D.drawString((String)object, this.endMarker.x, n3);
            } else if (this.endTime != null && this.endTime.length() > 0) {
                object = TimeRangeWidget.this.resolvePositionFromTime(this.endTime);
                this.endMarker = TimeRangeWidget.this.drawMarker(graphics2D, (Integer)object);
            }
            if (this.connection != null) {
                graphics2D.setColor(TimeRangeWidget.this.inactiveConnectorColor);
                if (navigableMap != null) {
                    int n6 = (int)(this.endMarker.getMinX() - this.startMarker.getMaxX());
                    Rectangle rectangle = new Rectangle((int)this.startMarker.getMaxX(), n2 + 3, n6, TimeRangeWidget.this._markerSize.height - 5);
                    graphics2D.fill(rectangle);
                    this.connection = rectangle;
                } else {
                    graphics2D.fill(this.connection);
                }
                graphics2D.setColor(Color.BLACK);
            } else if (this.startMarker != null && this.endMarker != null) {
                this.connection = TimeRangeWidget.this.connectMarkers(graphics2D, (int)this.startMarker.getMaxX(), (int)this.endMarker.getMinX());
            }
            this.reset(graphics2D);
        }
    }
}

