/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanListener;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.ContextMenuFactory;
import net.model3x.swing.DelegateTable;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.M3Layout;
import net.model3x.swing.M3Panel;
import net.model3x.swing.PropertyContextColumnHandler;
import net.model3x.swing.RendererFactory;
import net.model3x.swing.beanprops.BeanViewsFactory;
import net.model3x.swing.beanprops.TableViewDefinition;
import net.model3x.swing.table.TableModelColumnHelper;

public class SmartTable<T>
extends JComponent
implements TableModelColumnHelper<T> {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final long serialVersionUID = 1L;
    @Inject
    HStringProvider _stringProvider;
    @Inject
    RendererFactory _rendererFactory;
    @Inject
    ContextMenuFactory _contextMenuFactory;
    @Inject
    BeanViewsFactory _beanViewsFactory;
    final IBeanContext _beanContext;
    final IPropertyContext _propertyContext;
    final IBeanTableModel<T> _tableModel;
    DelegateTable _table = new DelegateTable();
    M3Panel _tableHeaderContainer = new M3Panel("ins 0, fillx");
    int _lastPaintColumntCount = -1;
    JButton _addRowButton = new JButton();
    boolean _addStandardMouseClickAdapter = true;

    public SmartTable(IPropertyContext iPropertyContext) {
        DependencyInjector.inject((Object)this);
        this._propertyContext = iPropertyContext;
        this._beanContext = BeanContainer.get().getContext(iPropertyContext.getType());
        this._tableModel = new BeanTableModel<T>();
        this.init();
    }

    public SmartTable(Class<T> clazz) {
        DependencyInjector.inject((Object)this);
        this._beanContext = BeanContainer.get().getContext(clazz);
        this._tableModel = new BeanTableModel<T>();
        this._propertyContext = null;
        this.init();
    }

    public SmartTable(Class<T> clazz, BeanTableModel<T> beanTableModel) {
        DependencyInjector.inject((Object)this);
        this._beanContext = BeanContainer.get().getContext(clazz);
        this._tableModel = beanTableModel;
        this._propertyContext = null;
        this.init();
    }

    public SmartTable(Class<T> clazz, BeanTableModel<T> beanTableModel, boolean bl) {
        DependencyInjector.inject((Object)this);
        this._beanContext = BeanContainer.get().getContext(clazz);
        this._tableModel = beanTableModel;
        this._propertyContext = null;
        this._addStandardMouseClickAdapter = bl;
        this.init();
    }

    private void init() {
        this._table.setModel(this._tableModel);
        this.setLayout((LayoutManager)new M3Layout("fillx, insets 0, hidemode 3"));
        this._tableHeaderContainer.add((Component)this._table.getTableHeader(), (Object)"growx");
        this.add((Component)this._tableHeaderContainer, "growx,wrap");
        this.add((Component)this._table, "growx, wrap");
        this.add((Component)this._addRowButton, "right, wrap");
        this._addRowButton.setText("Add " + this._beanContext.getDisplayName());
        this._addRowButton.setVisible(false);
        this.setDoubleBuffered(true);
        this._table.setRowSorter(this.getModel().getRowSorter());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SmartTable.this._table.setRollOverRowIndex(-1);
                SmartTable.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = SmartTable.this._table.rowAtPoint(mouseEvent.getPoint());
                if (n != SmartTable.this._table.getRollOverRowIndex()) {
                    SmartTable.this._table.setRollOverRowIndex(n);
                    SmartTable.this.repaint();
                }
            }
        };
        this._table.addMouseListener(mouseAdapter);
        this._table.addMouseMotionListener(mouseAdapter);
        this._table.setCursor(Cursor.getPredefinedCursor(12));
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -347184672129699492L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                ColumnHandler columnHandler = SmartTable.this.getModel().getColumn(tableColumn.getModelIndex());
                if (object == null) {
                    object = "";
                } else if (object instanceof Collection) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object e : (Collection)object) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(columnHandler.getHStringAdapter().valueToString(e));
                    }
                    object = stringBuilder.toString();
                } else {
                    object = columnHandler.getHStringAdapter().valueToString(object);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this._table.setSelectionMode(0);
        if (this._addStandardMouseClickAdapter) {
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (GuiHelper.isContextMenuTrigger((MouseEvent)mouseEvent) && (n = SmartTable.this._table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                        int n2 = SmartTable.this._table.convertRowIndexToModel(n);
                        Object t = SmartTable.this.getModel().getRow(n2);
                        SmartTable.this._contextMenuFactory.show(t, SmartTable.this._table, mouseEvent.getPoint());
                    }
                }
            });
        }
        if (this.getModel().getColumnCount() == 0) {
            TableViewDefinition tableViewDefinition = this._propertyContext != null ? this._beanViewsFactory.getTableViewDefinition(this._propertyContext) : this._beanViewsFactory.getTableViewDefinition(this._beanContext.getType());
            BeanTableModel.addColumns(this.getModel(), tableViewDefinition.getProperties());
            for (IPropertyContext iPropertyContext : tableViewDefinition.getNonVisibleProperties()) {
                this.getModel().getAllColumns().add(new PropertyContextColumnHandler(iPropertyContext));
            }
        }
    }

    @Override
    public IBeanTableModel<T> getModel() {
        return this._tableModel;
    }

    void initializeDefaultCellRenderers() {
        this.getModel().initializeDefaultCellRenderers(this._table, this._rendererFactory);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._lastPaintColumntCount != this.getModel().getColumnCount()) {
            this.initializeDefaultCellRenderers();
            this._lastPaintColumntCount = this.getModel().getColumnCount();
        }
        super.paint(graphics);
    }

    public Color getOddRowBackground() {
        return this._table.getOddRowBackground();
    }

    public Color getEvenRowBackground() {
        return this._table.getEvenRowBackground();
    }

    public void setEvenRowBackground(Color color) {
        this._table.setEvenRowBackground(color);
    }

    public void setOddRowBackground(Color color) {
        this._table.setOddRowBackground(color);
    }

    public void addSimpleSelectionListener(final BeanListener<T> beanListener) {
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object var2_2 = null;
                    try {
                        int n = SmartTable.this._table.convertRowIndexToModel(SmartTable.this._table.getSelectedRow());
                        var2_2 = SmartTable.this.getModel().getRow(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var2_2 == null) {
                        // empty if block
                    }
                    beanListener.beanEvent(var2_2);
                }
            }
        });
    }

    public JButton getAddRowButton() {
        return this._addRowButton;
    }

    public void setRolloverBackground(Color color) {
        this._table.setRolloverBackground(color);
    }

    public void setRolloverForeground(Color color) {
        this._table.setRolloverForeground(color);
    }

    public Color getRolloverForeground() {
        return this._table.getRolloverForeground();
    }

    public Color getRolloverBackground() {
        return this._table.getRolloverForeground();
    }

    public int rowAtPoint(Point point) {
        return this._table.rowAtPoint(point);
    }

    @Override
    public JTable getTableImpl() {
        return this._table;
    }

    @Override
    public void setName(String string) {
        this._table.setName(string);
    }

    public void clearSelection() {
        this._table.clearSelection();
    }

    public static <T> SmartTable<T> create(Class<?> clazz) {
        return new SmartTable(clazz);
    }

    public static <T> SmartTable<T> create(IPropertyContext iPropertyContext) {
        return new SmartTable<T>(iPropertyContext);
    }

    public void setRows(List<T> list) {
        this.getModel().setRows(list);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        this._tableHeaderContainer.removeAll();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JScrollPane jScrollPane;
            JViewport jViewport;
            Container container2 = container.getParent();
            if (container2 instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)container2).getViewport()) != null && jViewport.getView() == this) {
                Border border;
                this._tableHeaderContainer.setVisible(false);
                jScrollPane.setColumnHeaderView(this._table.getTableHeader());
                Border border2 = jScrollPane.getBorder();
                if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                    jScrollPane.setBorder(border);
                }
            }
        } else {
            this._tableHeaderContainer.setVisible(true);
            this._tableHeaderContainer.add((Component)this._table.getTableHeader(), (Object)"growx");
        }
        GuiHelper.doLayoutHack((Component)this._tableHeaderContainer);
    }

    public void setSortColumn(IPropertyContext iPropertyContext, SortOrder sortOrder) {
        int n = -1;
        for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            ColumnHandler<T> columnHandler = this._tableModel.getColumn(i);
            if (!(columnHandler instanceof PropertyContextColumnHandler) || !((PropertyContextColumnHandler)columnHandler).getPropertyContext().equals(iPropertyContext)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            this.getTableImpl().getRowSorter().setSortKeys(ListX.create((Object[])new RowSorter.SortKey[]{new RowSorter.SortKey(n, sortOrder)}));
        }
    }

    @Override
    public List<ColumnHandler<T>> getDisplayedColumns() {
        return this._tableModel.getColumns();
    }

    @Override
    public List<ColumnHandler<T>> getAllColumns() {
        return this._tableModel.getAllColumns();
    }

    @Override
    public void addColumn(ColumnHandler<T> columnHandler, int n) {
        this._tableModel.addColumn(columnHandler, n);
    }

    @Override
    public void removeColumn(ColumnHandler<T> columnHandler) {
        this._tableModel.removeColumn(columnHandler);
    }

    @Override
    public JTableHeader getTableHeader() {
        return this._table.getTableHeader();
    }

    @Override
    public int columnIndex(ColumnHandler<T> columnHandler) {
        return this._tableModel.columnIndex(columnHandler);
    }

    @Override
    public JPanel getTableHeaderContainer() {
        return this._tableHeaderContainer;
    }

    static {
        logger.toString();
    }
}

