/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.dev.properties.container.IPropertyContext;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Size;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.M3Panel;
import net.model3x.swing.RegexFilterTextfieldAdapter;
import net.model3x.swing.SmartTable;
import net.model3x.swing.uistate.FrameStateMarshaller;

public class SelectionPopup<T> {
    SmartTable<T> _table;
    Window _window;
    JPanel _contentPanel;
    String _title;
    SelectionListener<T> _selectionListener;
    Size _size;
    String _uiStateName;
    Class<?> _type;
    JTextField _searchField = new JTextField();

    public SelectionPopup(Class<?> clazz, String string, String string2) {
        this._table = SmartTable.create(clazz);
        this._type = clazz;
        this._title = string;
        this._uiStateName = string2;
    }

    public SelectionPopup(IPropertyContext iPropertyContext, String string, String string2) {
        this._table = SmartTable.create(iPropertyContext);
        this._type = iPropertyContext.getType();
        this._title = string;
        this._uiStateName = string2;
    }

    public JButton getAddRecordButton() {
        return this._table.getAddRowButton();
    }

    public void close() {
        if (this._window != null) {
            this._window.setVisible(false);
        }
    }

    public BeanTableModel<T> getTableModel() {
        return (BeanTableModel)this._table.getTableImpl().getModel();
    }

    public void show(Point point) {
        this._window = new JFrame(this._title);
        this.showImpl(point);
    }

    private void showImpl(Point point) {
        this._contentPanel = new M3Panel("fill", "[]rel[grow,fill]");
        this._contentPanel.add(new JLabel("Search:"));
        this._contentPanel.add((Component)this._searchField, "wrap, growx");
        this._contentPanel.add((Component)new JScrollPane(this._table), "grow, spanx, wrap");
        this._table.setName("dataTable");
        this.getTableModel().setPreferredWidths(this._table.getTableImpl().getColumnModel());
        this._table.getTableImpl().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Integer n = null;
                    try {
                        n = SelectionPopup.this._table.getTableImpl().convertRowIndexToModel(listSelectionEvent.getFirstIndex());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n == null) {
                        try {
                            n = SelectionPopup.this._table.getTableImpl().convertRowIndexToModel(listSelectionEvent.getLastIndex());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (n != null && n >= 0) {
                        Object t = SelectionPopup.this.getTableModel().getRow(n);
                        SelectionPopup.this._selectionListener.rowSelected(t);
                    }
                }
            }
        });
        this._window.add(this._contentPanel);
        if (this.getSize() != null) {
            this._window.setSize(this.getSize().asDimension());
        } else {
            this._window.pack();
        }
        this._window.setName(this._uiStateName);
        GuiHelper.positionWindowFullyOnScreen((Window)this._window, (Point)point, (GuiHelper.LocationType)GuiHelper.LocationType.UpperLeft);
        ((FrameStateMarshaller)DependencyInjector.get().getInstance(FrameStateMarshaller.class)).attach(this._window);
        new RegexFilterTextfieldAdapter(this._table._tableModel, this._table.getTableImpl(), this._searchField);
        this._window.setVisible(true);
    }

    public void showInModalDialog(Point point) {
        JDialog jDialog = new JDialog(null, Dialog.ModalityType.APPLICATION_MODAL);
        this._window = jDialog;
        jDialog.setResizable(true);
        this.showImpl(point);
    }

    public JPanel getContentPanel() {
        return this._contentPanel;
    }

    public Window getWindow() {
        return this._window;
    }

    public void setSelectionListener(SelectionListener<T> selectionListener) {
        this._selectionListener = selectionListener;
    }

    public void setSize(Size size) {
        this._size = size;
    }

    public Size getSize() {
        return this._size;
    }

    public void setRows(List<T> list) {
        this._table.setRows(list);
    }

    public JTextField getSearchField() {
        return this._searchField;
    }

    public static interface SelectionListener<T> {
        public void rowSelected(T var1);
    }
}

