/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.RegexFilter;
import net.model3x.swing.RowFilterX;
import net.model3x.swing.StringRowFilter;
import org.jdesktop.xswingx.PromptSupport;

public class RegexFilterTextfieldAdapter {
    private static final long serialVersionUID = 1L;
    IBeanTableModel<Object> _tableModel;
    JTable _table;
    JTextField _textField;
    RowFilter<BeanTableModel<Object>, Integer> _delegateFilter;
    int _previousLength = 0;
    int _minimumTextLengthForFiltering = 2;
    boolean _useRegexFilter = false;

    public RegexFilterTextfieldAdapter(IBeanTableModel<?> iBeanTableModel, JTable jTable, JTextField jTextField) {
        this._table = jTable;
        this._textField = jTextField;
        this.setTableModel(iBeanTableModel);
    }

    public void setTableModel(IBeanTableModel<?> iBeanTableModel) {
        this._tableModel = iBeanTableModel;
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfieldAdapter.this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfieldAdapter.this.filterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfieldAdapter.this.filterChanged();
            }
        });
        RowFilterX.addFilterToRowSorter(this._tableModel.getRowSorter(), new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                if (RegexFilterTextfieldAdapter.this.getDelegateFilter() == null) {
                    return true;
                }
                return RegexFilterTextfieldAdapter.this.getDelegateFilter().include(entry);
            }
        });
        PromptSupport.setPrompt((String)"Search", (JTextComponent)this._textField);
    }

    void filterChanged() {
        if (this._textField.getText().length() >= this._minimumTextLengthForFiltering || this._previousLength >= this._minimumTextLengthForFiltering && this._textField.getText().length() < this._minimumTextLengthForFiltering) {
            this._delegateFilter = null;
            this._tableModel.getRowSorter().sort();
        }
        this._previousLength = this._textField.getText().length();
    }

    public RowFilter<BeanTableModel<Object>, Integer> getDelegateFilter() {
        if (this._delegateFilter == null && this._textField.getText().length() >= this._minimumTextLengthForFiltering) {
            if (this._useRegexFilter) {
                Pattern pattern = Pattern.compile(this._textField.getText(), 2);
                this._delegateFilter = new RegexFilter<BeanTableModel<Object>, Integer>(pattern);
            } else {
                this._delegateFilter = new StringRowFilter<BeanTableModel<Object>, Integer>(this._textField.getText());
            }
        }
        return this._delegateFilter;
    }
}

