/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Inject;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideButton;
import css.CssHelper;
import css.Stylesheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.model3.collections.CollectionX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.EventManager;
import net.model3.swing.GuiHelper;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Layout;
import net.model3x.swing.PopupBuilder;

public class QuickCombo
extends JComponent {
    static final Logger logger = LoggerHelper.getLogger();
    PopupBuilder _popupWindowBuilder = new PopupBuilder(this);
    JideButton _labelField = new JideButton();
    ComboBoxModel _model;
    ListDataListener _modelListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            QuickCombo.this.resetComponent();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            QuickCombo.this.resetComponent();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            QuickCombo.this.resetComponent();
        }
    };
    int _popupXOffset = 8;
    @Inject
    HStringProvider _hStringProvider;
    EventManager<ActionListener> _eventManager;

    public QuickCombo(ComboBoxModel comboBoxModel) {
        this();
        this.setModel(comboBoxModel);
    }

    public QuickCombo(Object[] objectArray) {
        this();
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    public QuickCombo(Iterable<?> iterable) {
        this();
        this.setModel(new DefaultComboBoxModel<Object>(CollectionX.toObjectArray(iterable)));
    }

    public QuickCombo() {
        DependencyInjector.inject((Object)this);
        this._eventManager = EventManager.create();
        this._labelField.setFocusable(true);
        this.setLayout((LayoutManager)new M3Layout("fill,insets 0"));
        this.add((Component)this._labelField, "grow");
        this._labelField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                QuickCombo.this.showPopup(mouseEvent.getLocationOnScreen());
            }
        });
        this._labelField.setText("");
        this.setModel(new DefaultComboBoxModel());
    }

    void showPopup(Point point) {
        JidePopup jidePopup = this._popupWindowBuilder.getPopup();
        if (jidePopup.isPopupVisible()) {
            jidePopup.hidePopup();
        }
        JPanel jPanel = new JPanel((LayoutManager)new M3Layout("fillx,gap 0 0,insets 5"));
        CssHelper.addStyleClass((Component)jPanel, (String)"QuickCombo-popup");
        JComponent jComponent = null;
        for (int i = 0; i < this._model.getSize(); ++i) {
            final Object e = this._model.getElementAt(i);
            String string = this._hStringProvider.toString(e);
            JLabel jLabel = new JLabel(string);
            jLabel.setHorizontalAlignment(this._labelField.getHorizontalAlignment());
            jLabel.setHorizontalTextPosition(this._labelField.getHorizontalTextPosition());
            jPanel.add((Component)jLabel, "growx,wrap");
            jLabel.setFocusable(true);
            if (e.equals(this._model.getSelectedItem())) {
                jComponent = jLabel;
                CssHelper.addStyleClass((Component)jLabel, (String)"selected");
            }
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    QuickCombo.this._model.setSelectedItem(e);
                    QuickCombo.this.fireActionPerformed();
                    QuickCombo.this._popupWindowBuilder.hidePopup();
                }
            });
        }
        Stylesheet stylesheet = CssHelper.getStylesheet((Component)this);
        if (stylesheet == null) {
            logger.warn((Object)"no stylesheet found");
        } else {
            stylesheet.applyTo((Component)jPanel);
        }
        jPanel.doLayout();
        if (jComponent != null) {
            point.y -= jComponent.getY() + jComponent.getHeight() / 2;
        }
        point.x -= this._popupXOffset;
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        jidePopup.getContentPane().removeAll();
        jidePopup.getContentPane().add(jPanel);
        GuiHelper.doLayoutHack((Component)jidePopup.getContentPane());
        jidePopup.showPopup(point.x, point.y);
    }

    private void resetComponent() {
        String string;
        int n = 0;
        for (int i = 0; i < this._model.getSize(); ++i) {
            string = this._hStringProvider.toString(this._model.getElementAt(i));
            this._labelField.setText(string);
            this._labelField.doLayout();
            n = Math.max(n, this._labelField.getPreferredSize().width);
        }
        Object object = this._model.getSelectedItem();
        string = this._hStringProvider.toString(object);
        this._labelField.setText(string);
        Dimension dimension = this._labelField.getPreferredSize();
        dimension.width = n;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public ComboBoxModel getModel() {
        return this._model;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this._model;
        if (comboBoxModel2 != null) {
            comboBoxModel2.removeListDataListener(this._modelListener);
        }
        this._model = comboBoxModel;
        this._model.addListDataListener(this._modelListener);
    }

    public void setSelectedIndex(int n) {
        this._model.setSelectedItem(this._model.getElementAt(n));
    }

    public int getSelectedIndex() {
        Object object = this._model.getSelectedItem();
        for (int i = 0; i < this._model.getSize(); ++i) {
            if (object != this._model.getElementAt(i)) continue;
            return i;
        }
        return -1;
    }

    public <T> T getSelectedItem() {
        return (T)this._model.getSelectedItem();
    }

    public void setSelectedItem(Object object) {
        this._model.setSelectedItem(object);
    }

    void fireActionPerformed() {
        this._eventManager.safeDispatch((Visitor)new Visitor<ActionListener>(){

            public void visit(ActionListener actionListener) {
                actionListener.actionPerformed(null);
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this._eventManager.addListener((Object)actionListener);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._labelField.setFont(font);
    }

    public int getHorizontalAlignment() {
        return this._labelField.getHorizontalAlignment();
    }

    public int getHorizontalTextPosition() {
        return this._labelField.getHorizontalTextPosition();
    }

    public void setHorizontalAlignment(int n) {
        this._labelField.setHorizontalAlignment(n);
    }

    public void setHorizontalTextPosition(int n) {
        this._labelField.setHorizontalTextPosition(n);
    }

    @Override
    public void setBackground(Color color) {
        this._labelField.setBackground(color);
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        this._labelField.setForeground(color);
        super.setForeground(color);
    }

    public JidePopup getPopup() {
        return this._popupWindowBuilder.getPopup();
    }
}

