/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.jidesoft.popup.JidePopup;
import css.CssHelper;
import css.Stylesheet;
import java.awt.Component;

public class PopupBuilder {
    Component _parent;
    JidePopup _popup;
    boolean _applyStylesheet = true;

    public PopupBuilder(Component component) {
        this._parent = component;
        this._popup = new JidePopup();
        this._popup.setPopupType(2);
        this._popup.setFocusable(true);
        this._popup.setOwner(component);
    }

    public void showPopup() {
        this.ensureStylesheetIsApplied();
        this._popup.showPopup();
    }

    public void showPopup(int n, int n2, Component component) {
        this.ensureStylesheetIsApplied();
        this._popup.showPopup(n, n2, component);
    }

    private void ensureStylesheetIsApplied() {
        if (this._applyStylesheet) {
            this._applyStylesheet = false;
            Stylesheet stylesheet = CssHelper.getStylesheet((Component)this._parent);
            if (stylesheet != null) {
                stylesheet.applyTo((Component)this._popup);
            }
        }
    }

    public void hidePopup() {
        this._popup.hidePopup();
    }

    public void togglePopupVisibility() {
        if (this._popup.isVisible()) {
            this._popup.hidePopup();
        } else {
            this._popup.showPopup();
        }
    }

    public JidePopup getPopup() {
        return this._popup;
    }

    public boolean isPopupVisible() {
        return this._popup.isPopupVisible();
    }
}

