/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.lang.ObjectX;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.PropertyContextColumnHandler;
import net.model3x.swing.RendererFactory;

public class M3EventTableModel<TRow>
extends EventTableModel<TRow>
implements IBeanTableModel<TRow> {
    TableRowSorter<IBeanTableModel<TRow>> _rowSorter;
    protected boolean _ignoreToggleSortOrder = false;
    RowFilter<? super IBeanTableModel<TRow>, ? super Integer> _rowFilter = new RowFilter<IBeanTableModel<TRow>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends IBeanTableModel<TRow>, ? extends Integer> entry) {
            Object TRow = M3EventTableModel.this.getRow(entry.getIdentifier());
            int n = 0;
            for (ColumnHandler columnHandler : M3EventTableModel.this.getColumns()) {
                Object object = columnHandler.getColumnValue(TRow, n);
                if (!columnHandler.getFilter().include(object)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    };
    List<ColumnHandler<TRow>> _allColumns = ListX.create();

    @Override
    public void initializeDefaultCellRenderers(JTable jTable, RendererFactory rendererFactory) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellEditor tableCellEditor;
            ColumnHandler<TRow> columnHandler = this.getColumn(i);
            TableCellRenderer tableCellRenderer = columnHandler.getTableCellRenderer();
            if (tableCellRenderer == null && rendererFactory != null) {
                tableCellRenderer = rendererFactory.getTableCellRenderer(columnHandler.getColumnType());
            }
            if (tableCellRenderer != null) {
                jTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
            }
            if ((tableCellEditor = columnHandler.getTableCellEditor()) == null && rendererFactory != null) {
                tableCellEditor = rendererFactory.getTableCellEditor(columnHandler.getColumnType());
            }
            if (tableCellEditor == null) continue;
            jTable.getColumnModel().getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    @Override
    public void setRows(List<? extends TRow> list) {
        this.source.clear();
        this.source.addAll(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLiveRows(EventList<TRow> eventList) {
        EventList eventList2 = this.source;
        eventList2.getReadWriteLock().writeLock().lock();
        try {
            this.dispose();
            eventList.getReadWriteLock().readLock().lock();
            try {
                TransformedList transformedList = this.createSwingThreadProxyList(eventList);
                if (transformedList != null && transformedList != eventList) {
                    this.swingThreadSource = transformedList;
                    this.source = this.swingThreadSource;
                } else {
                    this.source = eventList;
                }
                this.source.addListEventListener((ListEventListener)this);
            }
            finally {
                this.source.getReadWriteLock().readLock().unlock();
            }
        }
        finally {
            eventList2.getReadWriteLock().writeLock().unlock();
        }
    }

    public M3EventTableModel(EventList<TRow> eventList) {
        super(eventList, new M3TableFormat());
    }

    @Override
    public int columnIndex(ColumnHandler<TRow> columnHandler) {
        return this.getColumns().indexOf(columnHandler);
    }

    public M3TableFormat<? super TRow> getTableFormat() {
        return (M3TableFormat)super.getTableFormat();
    }

    @Override
    public ColumnHandler<TRow> addColumn(PropertyContextable propertyContextable) {
        return this.addColumn(new PropertyContextColumnHandler(propertyContextable.getContext()));
    }

    @Override
    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler) {
        List list = (List)ObjectX.magicast(this.getTableFormat()._handlers);
        list.add(columnHandler);
        this.setTableFormat(new M3TableFormat(list));
        this.addAllColumn(columnHandler);
        return columnHandler;
    }

    @Override
    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler, int n) {
        this.addAllColumn(columnHandler);
        if (n < 0) {
            this.addColumn(columnHandler);
        } else {
            List list = (List)ObjectX.magicast(this.getTableFormat()._handlers);
            list.add(n, columnHandler);
            this.setTableFormat(new M3TableFormat(list));
        }
        this.fireTableStructureChanged();
        return columnHandler;
    }

    protected void addAllColumn(ColumnHandler<TRow> columnHandler) {
        if (!this._allColumns.contains(columnHandler)) {
            this._allColumns.add(columnHandler);
        }
    }

    @Override
    public TRow getRow(int n) {
        return (TRow)this.source.get(n);
    }

    @Override
    public ColumnHandler<TRow> getColumn(int n) {
        return (ColumnHandler)ObjectX.magicast(this.getTableFormat()._handlers.get(n));
    }

    @Override
    public TableRowSorter<IBeanTableModel<TRow>> getRowSorter() {
        if (this._rowSorter == null) {
            TableRowSorter tableRowSorter = new TableRowSorter<IBeanTableModel<TRow>>(this){

                @Override
                public void toggleSortOrder(int n) {
                    if (!M3EventTableModel.this._ignoreToggleSortOrder) {
                        super.toggleSortOrder(n);
                    }
                }
            };
            Comparator<Comparable<Object>> comparator = new Comparator<Comparable<Object>>(){

                @Override
                public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
                    return comparable.compareTo(comparable2);
                }
            };
            for (int i = 0; i < this.getTableFormat()._handlers.size(); ++i) {
                tableRowSorter.setComparator(i, comparator);
            }
            this.setRowSorter(tableRowSorter);
        }
        return this._rowSorter;
    }

    @Override
    public List<ColumnHandler<TRow>> getColumns() {
        return (List)ObjectX.magicast(this.getTableFormat()._handlers);
    }

    public void setRowSorter(TableRowSorter<IBeanTableModel<TRow>> tableRowSorter) {
        tableRowSorter.setRowFilter(this._rowFilter);
        this._rowSorter = tableRowSorter;
    }

    @Override
    public void clearColumns() {
        this.setTableFormat(new M3TableFormat());
    }

    @Override
    public boolean removeColumn(ColumnHandler<TRow> columnHandler) {
        List list = (List)ObjectX.magicast(this.getTableFormat()._handlers);
        boolean bl = list.remove(columnHandler);
        this.setTableFormat(new M3TableFormat(list));
        return bl;
    }

    @Override
    public List<ColumnHandler<TRow>> getAllColumns() {
        return this._allColumns;
    }

    @Override
    public List<? extends TRow> getRows() {
        return this.source;
    }

    @Override
    public void setIgnoreToggleSortOrder(boolean bl) {
        this._ignoreToggleSortOrder = bl;
    }

    @Override
    public int addRow(TRow TRow) {
        int n = this.getRowCount();
        this.source.add(TRow);
        return n;
    }

    @Override
    public void removeRow(TRow TRow) {
        this.source.remove(TRow);
    }

    @Override
    public int getRowIndex(TRow TRow) {
        return this.source.indexOf(TRow);
    }

    static class M3TableFormat<T>
    implements TableFormat<T> {
        List<ColumnHandler<T>> _handlers;

        public M3TableFormat() {
            this._handlers = ListX.create();
        }

        public M3TableFormat(List<ColumnHandler<T>> list) {
            this._handlers = list;
        }

        public int getColumnCount() {
            return this._handlers.size();
        }

        public String getColumnName(int n) {
            return this._handlers.get(n).getSingularName();
        }

        public Object getColumnValue(T t, int n) {
            return this._handlers.get(n).getColumnValue(t, -1);
        }
    }
}

