/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.model3.collections.ListX;
import net.model3.lang.ClassX;
import net.model3.lang.SystemX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class LookAndFeelHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    public static void howToSetAJGoodiesTheme() {
    }

    public static void addLookAndFeelMenuItems(JMenu jMenu, final Component ... componentArray) {
        final List list = ListX.create();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : LookAndFeelHelper.getPossibleLookAndFeels()) {
            final LookAndFeelHolder lookAndFeelHolder = new LookAndFeelHolder(lookAndFeelInfo);
            list.add(lookAndFeelHolder);
            jMenu.add(lookAndFeelHolder.getMenuItem());
            lookAndFeelHolder.getMenuItem().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (lookAndFeelHolder.getMenuItem().getState()) {
                        if (LookAndFeelHelper.setLookAndFeel(lookAndFeelHolder._lookAndFeelInfo.getClassName(), componentArray)) {
                            for (LookAndFeelHolder lookAndFeelHolder2 : list) {
                                lookAndFeelHolder2._menuItem.setState(lookAndFeelHolder2 == lookAndFeelHolder);
                            }
                        } else {
                            Component component = componentArray.length == 0 ? null : componentArray[0];
                            JOptionPane.showConfirmDialog(component, "Settting the look and feel failed.");
                            lookAndFeelHolder.getMenuItem().setState(false);
                        }
                    }
                }
            });
        }
    }

    public static boolean setLookAndFeel(String string, Component ... componentArray) {
        try {
            logger.info((Object)"setting look and feel to {}", (Object)string);
            UIManager.setLookAndFeel(string);
            logger.info((Object)"look and feel name is now {}", (Object)UIManager.getLookAndFeel().getName());
            for (Component component : componentArray) {
                try {
                    SwingUtilities.updateComponentTreeUI(component);
                }
                catch (Exception exception) {
                    logger.error((Object)"error updating the tree ui after a look and feel change", (Object)exception);
                }
            }
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"unable to set look and feel", (Object)exception);
            return false;
        }
    }

    public static List<UIManager.LookAndFeelInfo> getPossibleLookAndFeels() {
        List list = ListX.create();
        Object[] objectArray = UIManager.getInstalledLookAndFeels();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = objectArray[i];
            list.add(lookAndFeelInfo);
        }
        if (SystemX.isWindows()) {
            for (Object object : objectArray = new String[]{"JGoodies Windows:com.jgoodies.looks.windows.WindowsLookAndFeel", "JGoodies Plastic:com.jgoodies.looks.plastic.PlasticLookAndFeel", "JGoodies Plastic 3D:com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "JGoodies Plastic XP:com.jgoodies.looks.plastic.PlasticXPLookAndFeel"}) {
                String string = ((String)object).split(":")[0];
                String string2 = ((String)object).split(":")[1];
                LookAndFeelHelper.tryLookAndFeel(list, string, string2);
            }
        }
        LookAndFeelHelper.tryLookAndFeel(list, "Tiny", "de.muntjak.tinylookandfeel.TinyLookAndFeel");
        return list;
    }

    private static void tryLookAndFeel(List<UIManager.LookAndFeelInfo> list, String string, String string2) {
        try {
            ClassX.load((String)string2);
            list.add(new UIManager.LookAndFeelInfo(string, string2));
        }
        catch (Exception exception) {
            logger.trace((Object)"unable to load look and feel class {}", (Object)string2, (Object)exception);
        }
    }

    public static class LookAndFeelHolder {
        UIManager.LookAndFeelInfo _lookAndFeelInfo;
        JCheckBoxMenuItem _menuItem = new JCheckBoxMenuItem();

        LookAndFeelHolder(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this._lookAndFeelInfo = lookAndFeelInfo;
            this._menuItem.setText(lookAndFeelInfo.getName());
            this._menuItem.setState(this.isSelected());
        }

        public boolean isSelected() {
            return this._lookAndFeelInfo.getName().equals(UIManager.getLookAndFeel().getName());
        }

        public JCheckBoxMenuItem getMenuItem() {
            return this._menuItem;
        }

        public UIManager.LookAndFeelInfo getLookAndFeelInfo() {
            return this._lookAndFeelInfo;
        }

        public String toString() {
            return this._lookAndFeelInfo.getName();
        }
    }
}

