/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Singleton;
import css.CssHelper;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.imaging.ImageUtils;
import net.model3.imaging.Size;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;

@Singleton
public class IconFactory {
    private static final Logger logger = LoggerHelper.getLogger();
    Set<String> _missingIcons = SetX.createSynchronized();
    Map<String, ImageIcon> _iconCache = MapX.createSynchronized();
    ImageIcon _errorIcon = this.getIcon("error.png");
    ImageIcon _requiredIcon = this.getIcon("required-star.png");

    public IconFactory() {
        this._errorIcon = new ImageIcon(ImageUtils.createScaledImage((BufferedImage)((BufferedImage)this._errorIcon.getImage()), (Size)new Size(10, 10), (boolean)true, (boolean)true, (boolean)true));
        this._requiredIcon = new ImageIcon(ImageUtils.createScaledImage((BufferedImage)((BufferedImage)this._requiredIcon.getImage()), (Size)new Size(10, 10), (boolean)true, (boolean)true, (boolean)true));
    }

    public void linkIconToComponent(final JLabel jLabel, final JComponent jComponent, final boolean bl) {
        jComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                IconFactory.this.positionIcon(jLabel, jComponent, bl);
            }
        });
        this.positionIcon(jLabel, jComponent, bl);
    }

    public void positionIcon(JLabel jLabel, JComponent jComponent, boolean bl) {
        if (jComponent.isShowing()) {
            GuiHelper.makeSameLocationOnScreen((Component)jComponent, (Component)jLabel);
            Point point = jLabel.getLocation();
            int n = 2;
            int n2 = 3;
            point.x += n;
            if (bl) {
                point.y += n2;
                this.centerOn(jLabel, point);
            } else {
                point.y += jComponent.getHeight() - n2;
                this.centerOn(jLabel, point);
            }
        }
    }

    public JLabel createErrorIconLabel(JComponent jComponent) {
        JLabel jLabel = new JLabel(this._errorIcon);
        CssHelper.addStyleClass((Component)jLabel, (String)"errorIcon");
        this.linkIconToComponent(jLabel, jComponent, false);
        return jLabel;
    }

    public JLabel createRequiredIconLabel(JComponent jComponent) {
        JLabel jLabel = new JLabel(this._requiredIcon);
        this.linkIconToComponent(jLabel, jComponent, true);
        return jLabel;
    }

    void centerOn(JLabel jLabel, Point point) {
        jLabel.setSize(jLabel.getPreferredSize());
        int n = point.x - jLabel.getWidth() / 2;
        int n2 = point.y - jLabel.getHeight() / 2;
        jLabel.setLocation(n, n2);
    }

    public ImageIcon getIcon(String string) {
        ImageIcon imageIcon = this._iconCache.get(string);
        if (imageIcon == null && !this._missingIcons.contains(string)) {
            URL uRL = null;
            if (StringX.isNotBlank((String)string)) {
                uRL = ClassX.getResource((String)string);
            }
            if (uRL == null) {
                logger.warn((Object)"no image named {} found", (Object)string);
                this._missingIcons.add(string);
            } else {
                try {
                    BufferedImage bufferedImage = ImageIO.read(uRL);
                    imageIcon = new ImageIcon(bufferedImage);
                }
                catch (Exception exception) {
                    logger.warn((Object)"unable to load image {}", (Object)string, (Object)exception);
                    this._missingIcons.add(string);
                }
            }
        }
        return imageIcon;
    }
}

