/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.java.dev.properties.RProperty;
import net.model3.bean.ConverterFactory;
import net.model3.bean.ConverterFactoryImpl;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.lang.ClassX;
import net.model3.lang.NotImplementedException;

@Singleton
public class HStringProvider {
    protected ConverterFactory _converterFactory = new ConverterFactoryImpl(false);
    @Inject
    ConverterFactory _machineReadableConverterFactor;

    public HStringProvider() {
        this.initializeDefaultConverters();
    }

    public String propToString(RProperty<?> rProperty) {
        return this.toString(rProperty.get());
    }

    public String toString(Object object) {
        if (object == null) {
            return "";
        }
        Converter converter = this._converterFactory.getConverter(object.getClass());
        if (converter == null) {
            return object.toString();
        }
        return converter.valueToString(object);
    }

    protected void initializeDefaultConverters() {
    }

    public <T> HStringAdapter<T> getAdapter(Class<?> clazz) {
        HStringAdapter hStringAdapter = (HStringAdapter)this._converterFactory.getConverter(clazz);
        if (hStringAdapter == null) {
            Object object = this._machineReadableConverterFactor.getConverter(clazz);
            if (object == null) {
                object = new ConverterAdapter<Object>(){

                    public Object stringToValue(Class<?> clazz, String string) {
                        return string.toString();
                    }
                };
            }
            final Converter converter = object;
            hStringAdapter = new HStringAdapter<Object>(){

                @Override
                public String valueToString(Object object) {
                    return converter.valueToString(object);
                }
            };
            this._converterFactory.setConverter(clazz, (Converter)hStringAdapter);
        }
        return hStringAdapter;
    }

    public static enum Justification {
        Left(2),
        Center(0),
        Right(4);

        int _swingConstant;

        private Justification(int n2) {
            this._swingConstant = n2;
        }

        public int asSwingConstant() {
            return this._swingConstant;
        }
    }

    public static abstract class HStringAdapter<T>
    implements Converter<T> {
        Class<T> _clazz;
        Justification _justification;

        public HStringAdapter() {
            this._clazz = ClassX.getParameterizedType(this.getClass());
        }

        public HStringAdapter(Class<T> clazz) {
            this._clazz = clazz;
        }

        public HStringAdapter(Class<T> clazz, Justification justification) {
            this._clazz = clazz;
            this._justification = justification;
        }

        public T stringToValue(Class<?> clazz, String string) {
            throw new NotImplementedException();
        }

        public abstract String valueToString(T var1);

        public boolean canConvertType(Class<?> clazz) {
            return ClassX.isAssignable(this._clazz, clazz);
        }

        public Justification getJustification() {
            if (this._justification == null) {
                this._justification = ClassX.isAssignable(Number.class, this._clazz) ? Justification.Right : Justification.Left;
            }
            return this._justification;
        }
    }
}

