/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import net.model3.lang.Visitor;
import net.model3.swing.EventManager;
import net.model3.swing.GuiHelper;

public class FocusMonitor {
    Container _parent;
    EventManager<FocusListener> _listeners = EventManager.create();
    FocusListener _focusLostListener = new FocusAdapter(){

        @Override
        public void focusLost(final FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() == null || !GuiHelper.isParent((Component)FocusMonitor.this._parent, (Component)focusEvent.getOppositeComponent())) {
                FocusMonitor.this._listeners.safeDispatch((Visitor)new Visitor<FocusListener>(){

                    public void visit(FocusListener focusListener) {
                        focusListener.focusLost(focusEvent);
                    }
                });
            }
        }

        @Override
        public void focusGained(final FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() == null || !GuiHelper.isParent((Component)FocusMonitor.this._parent, (Component)focusEvent.getOppositeComponent())) {
                FocusMonitor.this._listeners.safeDispatch((Visitor)new Visitor<FocusListener>(){

                    public void visit(FocusListener focusListener) {
                        focusListener.focusGained(focusEvent);
                    }
                });
            }
        }
    };
    ContainerListener _containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            FocusMonitor.this.addComponentListeners(containerEvent.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            FocusMonitor.this.removeComponentListeners(containerEvent.getChild());
        }
    };

    public FocusMonitor(Container container) {
        this._parent = container;
        this.addComponentListeners(this._parent);
    }

    private void addComponentListeners(Component component) {
        GuiHelper.visitComponentAndDescendants((Component)component, (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                jComponent.removeContainerListener(FocusMonitor.this._containerListener);
                jComponent.removeFocusListener(FocusMonitor.this._focusLostListener);
                jComponent.addContainerListener(FocusMonitor.this._containerListener);
                jComponent.addFocusListener(FocusMonitor.this._focusLostListener);
            }
        });
    }

    private void removeComponentListeners(Component component) {
        GuiHelper.visitComponentAndDescendants((Component)component, (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                jComponent.removeContainerListener(FocusMonitor.this._containerListener);
                jComponent.removeFocusListener(FocusMonitor.this._focusLostListener);
            }
        });
    }

    public void addFocusListener(FocusListener focusListener) {
        this._listeners.addListener((Object)focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this._listeners.removeListener((Object)focusListener);
    }
}

