/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import ca.odell.glazedlists.EventList;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Set;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.swing.BeanTableModel;

public class FilteredTableModelBuilder<T> {
    Predicate<T> _filter = new Predicate<T>(){

        public boolean test(T t) {
            return this.apply(t);
        }

        public boolean apply(T t) {
            return true;
        }
    };
    BeanTableModel<T> _delegate;
    @Inject
    DataFeedService _dataFeedService;
    Set<T> _rows = SetX.create();
    Class<T> _type;
    boolean _attached;
    DataFeedListener<T> _dataFeedListener = new DataFeedListener<T>(){

        @Override
        public void beanAdded(T t) {
            FilteredTableModelBuilder.this.processRow(t);
        }

        @Override
        public void beanChanged(T t) {
            FilteredTableModelBuilder.this.processRow(t);
        }

        @Override
        public void beanRemoved(T t) {
            FilteredTableModelBuilder.this.removeRow(t);
        }

        @Override
        public void newBeanList(EventList<T> eventList) {
            FilteredTableModelBuilder.this._delegate.clearAllRows();
            FilteredTableModelBuilder.this._rows.clear();
            for (Object e : eventList) {
                FilteredTableModelBuilder.this.processRow(e);
            }
        }
    };

    public FilteredTableModelBuilder() {
        DependencyInjector.inject((Object)this);
        this._type = ClassX.getParameterizedType(this.getClass());
        this._type.toString();
        this._delegate = new BeanTableModel();
    }

    public FilteredTableModelBuilder(Class<T> clazz) {
        DependencyInjector.inject((Object)this);
        this._type = clazz;
        this._type.toString();
        this._delegate = new BeanTableModel();
    }

    public FilteredTableModelBuilder(Class<T> clazz, Predicate<T> predicate) {
        this(clazz);
        this._filter = predicate;
        this._delegate = new BeanTableModel();
    }

    public FilteredTableModelBuilder(Predicate<T> predicate) {
        this();
        this._filter = predicate;
        this._delegate = new BeanTableModel();
    }

    public FilteredTableModelBuilder(BeanTableModel<T> beanTableModel, Predicate<T> predicate) {
        this();
        this._filter = predicate;
        this._delegate = beanTableModel;
    }

    public void setFilter(Predicate<T> predicate) {
        this._filter = predicate;
    }

    public void attachToDataFeed() {
        this._attached = true;
        this._dataFeedService.registerDataFeed(this.getType(), this._dataFeedListener);
    }

    Class<T> getType() {
        return ClassX.getParameterizedType(this.getClass());
    }

    void processRow(T t) {
        boolean bl;
        boolean bl2 = this._rows.contains(t);
        if (bl2 != (bl = this._filter.apply(t))) {
            if (bl) {
                this.addRowImpl(t);
            } else {
                this.removeRowImpl(t);
            }
        }
    }

    private void addRowImpl(T t) {
        this._rows.add(t);
        this._delegate.addRow(t);
    }

    void removeRow(T t) {
        if (this._rows.contains(t)) {
            this.removeRowImpl(t);
        }
    }

    private void removeRowImpl(T t) {
        this._rows.remove(t);
        this._delegate.removeRow((Object)t);
    }

    public BeanTableModel<T> getTableModel() {
        if (!this._attached) {
            this.attachToDataFeed();
        }
        return this._delegate;
    }

    public void resetFilter() {
        EventList<T> eventList = this._dataFeedService.getDataFeed(this.getType());
        if (eventList != null) {
            this._dataFeedListener.newBeanList(eventList);
        }
    }
}

