/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ObjectX;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.swing.HStringProvider;

public class EntityComboBoxModel<T>
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 2462597237665753013L;
    String _nullText = "";
    private List<String> _visualItems = new ArrayList<String>();
    private List<T> _entities = new ArrayList<T>();
    private String _selectedItem;
    private T _selectedEntity;
    private boolean _nullable;
    private int _nullableOffset;
    private T _default;
    private HStringProvider.HStringAdapter<T> _stringConverter;
    DataFeedListener<T> _dataFeedListener;

    public static <U> EntityComboBoxModel<U> create() {
        return new EntityComboBoxModel(new ArrayList());
    }

    public EntityComboBoxModel(T[] TArray) {
        this(CollectionX.toList((Object[])TArray));
    }

    public EntityComboBoxModel() {
        this(ListX.create());
    }

    public EntityComboBoxModel(Iterable<T> iterable) {
        this.setNullable(false);
        this.setItems(iterable);
    }

    public void setItems(Iterable<T> iterable) {
        this.setItems(iterable, true);
    }

    public void setLiveItems(EventList<T> eventList) {
        this.setItems((Iterable<T>)eventList);
        eventList.addListEventListener(new ListEventListener<T>(){

            public void listChanged(ListEvent<T> listEvent) {
                if (listEvent.getType() == 2) {
                    EntityComboBoxModel.this._entities.add(listEvent.getNewValue());
                } else if (listEvent.getType() == 1) {
                    int n = EntityComboBoxModel.this._entities.indexOf(listEvent.getOldValue());
                    if (n >= 0) {
                        EntityComboBoxModel.this._entities.set(n, listEvent.getNewValue());
                    }
                } else if (listEvent.getType() == 0) {
                    EntityComboBoxModel.this._entities.remove(listEvent.getOldValue());
                }
                EntityComboBoxModel.this.resetVisuals();
                EntityComboBoxModel.this.fireEverythingHasChanged();
            }
        });
    }

    public void addEntity(T t) {
        if (t != null && this._entities.add(t)) {
            this.resetVisuals();
            this.fireEverythingHasChanged();
        }
    }

    public void addEntityAt(T t, int n) {
        if (t != null) {
            this._entities.add(n, t);
            this.resetVisuals();
            this.fireEverythingHasChanged();
        }
    }

    public void removeEntity(T t) {
        if (t != null && this._entities.remove(t)) {
            this.resetVisuals();
            this.fireEverythingHasChanged();
        }
    }

    public void removeEntityAt(int n) {
        if (n != 0 || !this._nullable) {
            this._entities.remove(n - this._nullableOffset);
            this.resetVisuals();
            this.fireEverythingHasChanged();
        }
    }

    @Override
    public int getSize() {
        return this._entities.size() + this._nullableOffset;
    }

    public void setNullable(boolean bl) {
        this._nullable = bl;
        this._nullableOffset = this._nullable ? 1 : 0;
        this.resetVisuals();
    }

    public void setItems(Iterable<T> iterable, boolean bl) {
        this._entities.clear();
        if (iterable != null) {
            for (T t : iterable) {
                this.addEntity(t);
            }
            if (bl) {
                Comparator comparator = new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        String string = EntityComboBoxModel.this.valueToString(t);
                        String string2 = EntityComboBoxModel.this.valueToString(t2);
                        return ObjectX.compareTo((Object)string, (Object)string2);
                    }
                };
                Collections.sort(this._entities, comparator);
            }
        }
        this.resetVisuals();
        this.fireEverythingHasChanged();
    }

    public void resetVisuals() {
        List list = ListX.create();
        for (T t : this._entities) {
            list.add(this.valueToString(t));
        }
        this._visualItems = list;
        this.fireEverythingHasChanged();
    }

    protected String valueToString(T t) {
        if (t == null) {
            return this._nullText;
        }
        if (this._stringConverter == null) {
            this._stringConverter = ((HStringProvider)DependencyInjector.getInstance(HStringProvider.class)).getAdapter(t.getClass());
        }
        return this._stringConverter.valueToString(t);
    }

    public void setStringConverter(HStringProvider.HStringAdapter<T> hStringAdapter) {
        this._stringConverter = hStringAdapter;
    }

    public T getEntityAt(int n) {
        if (n == 0 && this._nullable) {
            return null;
        }
        return this._entities.get(n - this._nullableOffset);
    }

    public List<String> getVisualItems() {
        return this._visualItems;
    }

    @Override
    public Object getElementAt(int n) {
        if (this._visualItems == null || this._visualItems.isEmpty() || n == 0 && this._nullable || n < 0 || n >= this.getSize()) {
            return this._nullText;
        }
        return this._visualItems.get(n - this._nullableOffset);
    }

    @Override
    public void setSelectedItem(Object object) {
        String string;
        Object var3_2;
        if (object == null || object.equals(this._nullText)) {
            var3_2 = null;
            string = null;
        } else {
            int n = this._visualItems.indexOf(object);
            string = this._visualItems.get(n);
            var3_2 = this._entities.get(n);
        }
        this._selectedEntity = var3_2;
        this._selectedItem = string;
        this.fireEverythingHasChanged();
    }

    public void fireItemChanged(T t) {
        int n = this._entities.indexOf(t);
        if (n >= 0) {
            this.fireContentsChanged(this, n, n);
        }
    }

    public void fireEverythingHasChanged() {
        this.fireContentsChanged(this, 0, this._entities.size() + this._nullableOffset);
    }

    public T getSelectedEntity() {
        return this._selectedEntity;
    }

    public void setSelectedEntity(T t) {
        String string = null;
        Object var3_3 = null;
        if (t != null) {
            int n = this._entities.indexOf(t);
            if (!this._entities.isEmpty() && n >= 0) {
                string = this._visualItems.get(n);
                var3_3 = t;
            }
        }
        this._selectedEntity = var3_3;
        this._selectedItem = string;
        this.fireEverythingHasChanged();
    }

    @Override
    public Object getSelectedItem() {
        if (this._selectedItem == null) {
            return this._nullText;
        }
        return this._selectedItem;
    }

    public void setDefault(T t) {
        this._default = t;
    }

    public void registerDataFeed(Class<T> clazz) {
        if (this._dataFeedListener == null) {
            this._dataFeedListener = ((DataFeedService)DependencyInjector.getInstance(DataFeedService.class)).registerDataFeed(clazz, new DataFeedListener<T>(){

                @Override
                public void beanAdded(T t) {
                    if (!EntityComboBoxModel.this._entities.contains(t)) {
                        EntityComboBoxModel.this.addEntity(t);
                    }
                }

                @Override
                public void beanRemoved(T t) {
                    if (EntityComboBoxModel.this._entities.contains(t)) {
                        EntityComboBoxModel.this.removeEntity(t);
                    }
                }

                @Override
                public void beanChanged(T t) {
                    int n = EntityComboBoxModel.this._entities.indexOf(t);
                    if (n >= 0) {
                        EntityComboBoxModel.this._visualItems.set(n, EntityComboBoxModel.this.valueToString(t));
                        EntityComboBoxModel.this.fireContentsChanged(this, n, n);
                    }
                }

                @Override
                public void newBeanList(EventList<T> eventList) {
                    EntityComboBoxModel.this.setItems(eventList);
                }
            });
        }
    }

    public T getDefault() {
        if (this._default == null && this._entities.size() == 1) {
            this._default = this._entities.get(0);
        }
        return this._default;
    }

    public void setNullText(String string) {
        this._nullText = string;
        this.resetVisuals();
    }

    public String getNullText() {
        return this._nullText;
    }

    public boolean containsEntity(T t) {
        return this._entities.contains(t);
    }

    public void reset() {
        this.setSelectedEntity(this.getDefault());
    }
}

