/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;

public class DragAndDropTableDecorator {
    boolean canSelect = true;
    boolean isDragging;
    MouseEvent pressEvent = null;
    JTable _table;

    public DragAndDropTableDecorator(JTable jTable) {
        this._table = jTable;
        MouseHandler mouseHandler = new MouseHandler();
        this._table.addMouseListener(mouseHandler);
        this._table.addMouseMotionListener(mouseHandler);
        this._table.setSelectionModel(new ListSelectionModelWrapper(this._table.getSelectionModel()));
        this._table.getColumnModel().setSelectionModel(new ListSelectionModelWrapper(this._table.getColumnModel().getSelectionModel()));
    }

    class ListSelectionModelWrapper
    implements ListSelectionModel {
        ListSelectionModel _listSelectionModel;

        private ListSelectionModelWrapper(ListSelectionModel listSelectionModel) {
            this._listSelectionModel = listSelectionModel;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.addListSelectionListener(listSelectionListener);
            }
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.addSelectionInterval(n, n2);
            }
        }

        @Override
        public void clearSelection() {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.clearSelection();
            }
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this._listSelectionModel.getAnchorSelectionIndex();
        }

        @Override
        public int getLeadSelectionIndex() {
            return this._listSelectionModel.getLeadSelectionIndex();
        }

        @Override
        public int getMaxSelectionIndex() {
            return this._listSelectionModel.getMaxSelectionIndex();
        }

        @Override
        public int getMinSelectionIndex() {
            return this._listSelectionModel.getMinSelectionIndex();
        }

        @Override
        public int getSelectionMode() {
            return this._listSelectionModel.getSelectionMode();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this._listSelectionModel.getValueIsAdjusting();
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.insertIndexInterval(n, n2, bl);
            }
        }

        @Override
        public boolean isSelectedIndex(int n) {
            return this._listSelectionModel.isSelectedIndex(n);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this._listSelectionModel.isSelectionEmpty();
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.removeIndexInterval(n, n2);
            }
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.removeListSelectionListener(listSelectionListener);
            }
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.removeSelectionInterval(n, n2);
            }
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.setAnchorSelectionIndex(n);
            }
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.setLeadSelectionIndex(n);
            }
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.setSelectionInterval(n, n2);
            }
        }

        @Override
        public void setSelectionMode(int n) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.setSelectionMode(n);
            }
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
            if (DragAndDropTableDecorator.this.canSelect) {
                this._listSelectionModel.setValueIsAdjusting(bl);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
            DragAndDropTableDecorator.this.isDragging = false;
            DragAndDropTableDecorator.this.pressEvent = mouseEvent;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
            DragAndDropTableDecorator.this.isDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = false;
            if (!DragAndDropTableDecorator.this.isDragging && DragAndDropTableDecorator.this.pressEvent != null) {
                TransferHandler transferHandler = DragAndDropTableDecorator.this._table.getTransferHandler();
                transferHandler.exportAsDrag(DragAndDropTableDecorator.this._table, DragAndDropTableDecorator.this.pressEvent, 2);
            }
            DragAndDropTableDecorator.this.pressEvent = null;
            DragAndDropTableDecorator.this.isDragging = true;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DragAndDropTableDecorator.this.canSelect = true;
        }
    }
}

