/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DelegateTable
extends JTable {
    private static final long serialVersionUID = -7608026671224637414L;
    private boolean canSelect = true;
    private boolean isDragging;
    private MouseEvent pressEvent = null;
    int _rollOverRowIndex = -1;
    Color _oddRowBackground;
    Color _evenRowBackground = new Color(232, 232, 232);
    Color _rolloverForeground;
    Color _rolloverBackground;
    boolean _showRollover = true;
    DefaultTableCellRenderer _defaultCellRenderer = new DefaultTableCellRenderer();

    public DelegateTable() {
    }

    public DelegateTable(TableModel tableModel) {
        super(tableModel);
    }

    public DelegateTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public DelegateTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        boolean bl = this.canSelect = mouseEvent.getID() != 506;
        if (mouseEvent.getID() == 501) {
            this.isDragging = false;
            this.pressEvent = mouseEvent;
        } else if (mouseEvent.getID() == 506) {
            if (!this.isDragging && this.pressEvent != null) {
                TransferHandler transferHandler = this.getTransferHandler();
                transferHandler.exportAsDrag(this, this.pressEvent, 1);
            }
            this.pressEvent = null;
            this.isDragging = true;
        } else if (mouseEvent.getID() == 502) {
            this.isDragging = false;
        }
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.canSelect) {
            super.changeSelection(n, n2, bl, bl2);
        }
    }

    @Override
    public void setColumnSelectionInterval(int n, int n2) {
        if (this.canSelect) {
            super.setColumnSelectionInterval(n, n2);
        }
    }

    @Override
    public void setRowSelectionInterval(int n, int n2) {
        if (this.canSelect) {
            super.setRowSelectionInterval(n, n2);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (tableCellRenderer == null) {
            tableCellRenderer = this._defaultCellRenderer;
        }
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n == this._rollOverRowIndex && this._showRollover) {
            component.setForeground(this.getRolloverForeground());
            component.setBackground(this.getRolloverBackground());
        } else if (this.isRowSelected(n)) {
            component.setForeground(this.getSelectionForeground());
            component.setBackground(this.getSelectionBackground());
        } else if (n % 2 == 1) {
            component.setForeground(this.getForeground());
            component.setBackground(this.getEvenRowBackground());
        } else {
            component.setForeground(this.getForeground());
            component.setBackground(this.getOddRowBackground());
        }
        return component;
    }

    public int getRollOverRowIndex() {
        return this._rollOverRowIndex;
    }

    public void setRollOverRowIndex(int n) {
        this._rollOverRowIndex = n;
    }

    public void setRolloverBackground(Color color) {
        this._rolloverBackground = color;
    }

    public void setRolloverForeground(Color color) {
        this._rolloverForeground = color;
    }

    public Color getRolloverForeground() {
        if (this._rolloverForeground == null) {
            return this.getSelectionForeground();
        }
        return this._rolloverForeground;
    }

    public Color getRolloverBackground() {
        if (this._rolloverBackground == null) {
            return this.getSelectionBackground();
        }
        return this._rolloverBackground;
    }

    public Color getEvenRowBackground() {
        if (this._evenRowBackground == null) {
            return this.getBackground();
        }
        return this._evenRowBackground;
    }

    public void setEvenRowBackground(Color color) {
        this._evenRowBackground = color;
    }

    public void setOddRowBackground(Color color) {
        this._oddRowBackground = color;
    }

    public Color getOddRowBackground() {
        if (this._oddRowBackground == null) {
            return this.getBackground();
        }
        return this._oddRowBackground;
    }

    public void setShowRollover(boolean bl) {
        this._showRollover = bl;
    }
}

