/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.model3.guice.DependencyInjector;
import net.model3x.datafeed.DataFeedFormCommitter;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.swing.BeanListener;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.M3Layout;
import net.model3x.swing.RegexFilterTextfieldAdapter;
import net.model3x.swing.SmartGrid;
import net.model3x.swing.SmartTable;
import net.model3x.swing.beanprops.BeanViewsFactory;
import net.model3x.swing.beanprops.form.FormBuilder;

public class CrudWidget {
    @Inject
    DataFeedService _dataAccessService;
    @Inject
    BeanViewsFactory _beanViewsFactory;
    IBeanContext _beanContext;
    Class<Object> _type;
    FormBuilder<Object> _formBuilder;
    JComponent _form;
    SmartGrid _smartGrid;
    SmartTable _table;
    BeanTableModel<Object> _tableModel;
    JPanel _contentPanel;
    DataFeedListener<Object> _indexListener;

    public CrudWidget(Class<?> clazz) {
        DependencyInjector.inject((Object)this);
        this._smartGrid = SmartGrid.create(clazz);
        this._table = this._smartGrid.getSmartTable();
        this._type = clazz;
        this._beanContext = BeanContainer.get().getContext(this._type);
        this._indexListener = this._dataAccessService.attachTableModelToDataFeed(this._type, this.getTableModel());
        this.initSmartGrid();
    }

    public Class<?> getType() {
        return this._type;
    }

    public JComponent getContentPanel() {
        if (this._contentPanel != null) {
            return this._contentPanel;
        }
        this._contentPanel = new JPanel((LayoutManager)new M3Layout("fill"));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.add((Component)((Object)this.getSmartGrid()), "top");
        jSplitPane.add(this.createCenteringPanel(this.createScrollPane(this.getForm())), "bottom");
        jSplitPane.setName("CrudWidget-" + this._beanContext.getType().getName() + "-splitter");
        this._table.addSimpleSelectionListener(new BeanListener<Object>(){

            public void beanEvent(Object object) {
                if (object != null) {
                    CrudWidget.this.enableForm(object);
                } else {
                    CrudWidget.this.disableForm();
                }
            }
        });
        this._contentPanel.add((Component)jSplitPane, "grow, wrap");
        this.disableForm();
        return this._contentPanel;
    }

    private Component createCenteringPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel((LayoutManager)new M3Layout("insets 20,fill"));
        jPanel.add((Component)jComponent, "grow");
        return jPanel;
    }

    public IBeanContext getBeanContext() {
        return BeanContainer.get().getContext(this._type);
    }

    JComponent getForm() {
        this._formBuilder = this._beanViewsFactory.getFormDefinition(this.getType()).createFormBuilder();
        this._formBuilder.addListener(new DataFeedFormCommitter());
        this._form = this._formBuilder.getForm();
        return this._form;
    }

    void disableForm() {
        this._formBuilder.disable();
        this._table.clearSelection();
    }

    void enableForm(Object object) {
        this._formBuilder.enable(object);
    }

    public SmartGrid getSmartGrid() {
        return this._smartGrid;
    }

    void initSmartGrid() {
        this._table.setName("crudTable-" + this._type.getName());
        new RegexFilterTextfieldAdapter(this.getTableModel(), this._table.getTableImpl(), this._smartGrid.getSearchField());
        this.getTableModel().setPreferredWidths(this._table.getTableImpl().getColumnModel());
        this._smartGrid.getAddRowButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = CrudWidget.this._formBuilder.newInstance();
                CrudWidget.this.getTableModel().addRow(object);
                int n = CrudWidget.this.getTableModel().getRowIndex(object);
                if (n >= 0) {
                    n = CrudWidget.this._table.getTableImpl().convertRowIndexToView(n);
                    CrudWidget.this._table.getTableImpl().getSelectionModel().setValueIsAdjusting(false);
                    CrudWidget.this._table.clearSelection();
                    CrudWidget.this._table.getTableImpl().getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        this._smartGrid.getAddRowButton().setVisible(true);
    }

    private BeanTableModel<Object> getTableModel() {
        return (BeanTableModel)this._smartGrid.getSmartTable().getTableImpl().getModel();
    }

    JScrollPane createScrollPane(JComponent jComponent) {
        return new JScrollPane(jComponent);
    }
}

