/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Singleton;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.model3.collections.ListX;
import net.model3.lang.ClassX;

@Singleton
public class ContextMenuFactory {
    List<ContextMenuItem<Object>> _contextMenuItems = ListX.create();

    public void show(Object object, JComponent jComponent, Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (ContextMenuItem<Object> contextMenuItem : this._contextMenuItems) {
            if (!contextMenuItem.canHandleType(object.getClass()) || !contextMenuItem.canHandleInstance(object)) continue;
            contextMenuItem.populateMenu(jComponent, jPopupMenu, object);
        }
        jPopupMenu.show(jComponent, point.x, point.y);
    }

    public void show(Object object, JComponent jComponent, Point point, String ... stringArray) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        block0: for (String string : stringArray) {
            for (ContextMenuItem<Object> contextMenuItem : this._contextMenuItems) {
                if (!contextMenuItem.canHandleType(object.getClass()) || !contextMenuItem.canHandleInstance(object) || !string.equals(contextMenuItem.getName())) continue;
                contextMenuItem.populateMenu(jComponent, jPopupMenu, object);
                continue block0;
            }
        }
        jPopupMenu.show(jComponent, point.x, point.y);
    }

    public void add(ContextMenuItem<?> contextMenuItem) {
        this._contextMenuItems.add(contextMenuItem);
    }

    public static class ContextMenuEvent {
        JComponent _parent;
        JMenuItem _menuItem;
        Object _bean;

        public JComponent getParent() {
            return this._parent;
        }

        public JMenuItem getMenuItem() {
            return this._menuItem;
        }

        public Object getBean() {
            return this._bean;
        }
    }

    public static abstract class ContextMenuItem<T> {
        Class<T> _type;
        String _name;

        public ContextMenuItem(String string) {
            this._type = ClassX.getParameterizedType(this.getClass());
            this._name = string;
        }

        public ContextMenuItem(Class<T> clazz, String string) {
            this._type = clazz;
            this._name = string;
        }

        public String getName() {
            return this._name;
        }

        public String getTitle(T t) {
            return this._name;
        }

        public void populateMenu(final JComponent jComponent, JPopupMenu jPopupMenu, final T t) {
            final JMenuItem jMenuItem = new JMenuItem(this.getTitle(t));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ContextMenuEvent contextMenuEvent = new ContextMenuEvent();
                    contextMenuEvent._bean = t;
                    contextMenuEvent._menuItem = jMenuItem;
                    contextMenuEvent._parent = jComponent;
                    this.performAction(contextMenuEvent, t);
                }
            });
            jPopupMenu.add(jMenuItem);
        }

        public boolean canHandleType(Class<?> clazz) {
            return ClassX.isAssignable(this._type, clazz);
        }

        public boolean canHandleInstance(T t) {
            return true;
        }

        public void setType(Class<T> clazz) {
            this._type = clazz;
        }

        public abstract void performAction(ContextMenuEvent var1, T var2);
    }
}

