/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import com.google.inject.Inject;
import com.jidesoft.swing.TitledSeparator;
import css.CssHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.lang.ClassX;
import net.model3.swing.CurvedBorder;
import net.model3x.swing.BeanListener;
import net.model3x.swing.ComponentFactory;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.SelectionPopup;
import net.model3x.swing.beanprops.BeanViewsFactory;
import net.model3x.swing.beanprops.FormBuilderPopup;
import net.model3x.swing.beanprops.form.FormBuilder;
import net.model3x.swing.beanprops.form.FormDefinition;

public class ComponentFactoryImpl
implements ComponentFactory {
    ImageIcon _searchIcon;
    @Inject
    BeanViewsFactory _beanViewsFactory;
    FormBuilderPopup<?> _addEntityPopup;

    @Override
    public TitledBorder createTitledBorder(String string) {
        return this.createTitledBorder(string, HStringProvider.Justification.Left);
    }

    @Override
    public TitledBorder createTitledBorder(String string, HStringProvider.Justification justification) {
        int n = 4;
        if (justification == HStringProvider.Justification.Center) {
            n = 2;
        } else if (justification == HStringProvider.Justification.Right) {
            n = 5;
        }
        return new TitledBorder((Border)new CurvedBorder(Color.gray, 1, 20), string, n, 2);
    }

    @Override
    public JComponent createTitledSeperator(String string) {
        return new TitledSeparator(string);
    }

    @Override
    public JButton createSearchButton() {
        JButton jButton = new JButton(this.getSearchImageIcon());
        CssHelper.addStyleClass((Component)jButton, (String)"searchButton");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    @Override
    public ImageIcon getSearchImageIcon() {
        if (this._searchIcon == null) {
            this._searchIcon = new ImageIcon(ClassX.getResource((String)"find-16.png"));
        }
        return this._searchIcon;
    }

    @Override
    public void showEntitySelectionPopup(Component component, IPropertyContext iPropertyContext, BeanListener<?> beanListener) {
        SelectionPopup selectionPopup = new SelectionPopup(iPropertyContext, "Select " + iPropertyContext.getDisplayName(), iPropertyContext.toString() + "-selector");
        this.showEntitySelectionPopupImpl(component, selectionPopup, this._beanViewsFactory.getFormDefinition(iPropertyContext), iPropertyContext.getType(), beanListener);
    }

    @Override
    public <T> void showEntitySelectionPopup(Component component, Class<T> clazz, BeanListener<T> beanListener) {
        String string = BeanContainer.get().getContext(clazz).getDisplayName();
        SelectionPopup selectionPopup = new SelectionPopup(clazz, "Select " + string, clazz.getName() + "-selector");
        this.showEntitySelectionPopupImpl(component, selectionPopup, this._beanViewsFactory.getFormDefinition(clazz), clazz, beanListener);
    }

    protected <T> void showEntitySelectionPopupImpl(final Component component, final SelectionPopup<T> selectionPopup, final FormDefinition formDefinition, final Class<T> clazz, final BeanListener<T> beanListener) {
        selectionPopup.setRows(CurrentSession.get().selectAll(clazz));
        selectionPopup.setSelectionListener(new SelectionPopup.SelectionListener<T>(){

            @Override
            public void rowSelected(T t) {
                beanListener.beanEvent(t);
                selectionPopup.close();
            }
        });
        if (formDefinition != null) {
            selectionPopup.getAddRecordButton().setVisible(true);
            selectionPopup.getAddRecordButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    selectionPopup.close();
                    if (ComponentFactoryImpl.this._addEntityPopup == null) {
                        ComponentFactoryImpl.this._addEntityPopup = new FormBuilderPopup("AddEntityPopup");
                    }
                    final FormBuilder<Object> formBuilder = formDefinition.createFormBuilder();
                    formBuilder.enableButtons();
                    formBuilder.getSaveButton().setText("Create and Select");
                    formBuilder.getSaveButton().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            formBuilder.populateBean();
                            Object t = formBuilder.getBean();
                            CurrentSession.get().insert(t);
                            beanListener.beanEvent(t);
                            ComponentFactoryImpl.this._addEntityPopup.close();
                        }
                    });
                    formBuilder.configureAutoEnabledSaveButton();
                    formBuilder.getCancelButton().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ComponentFactoryImpl.this._addEntityPopup.close();
                        }
                    });
                    formBuilder.enable(BeanContainer.get().getContext(clazz).newInstance());
                    String string = "Add " + BeanContainer.get().getContext(clazz).getDisplayName();
                    ComponentFactoryImpl.this._addEntityPopup.show(formBuilder, component.getLocationOnScreen(), string);
                }
            });
        }
        selectionPopup.showInModalDialog(component.getLocationOnScreen());
    }
}

