/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.java.dev.properties.container.IPropertyContext;
import net.model3.collections.ListX;
import net.model3.lang.ObjectX;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.PropertyContextColumnHandler;
import net.model3x.swing.RowFilterX;

public class CheckBoxFilterComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BeanTableModel<Object> _tableModel;
    private ColumnHandler<Object> _column;
    private Set<Object> _values = new HashSet<Object>();
    private List<JCheckBox> _checkBoxes = ListX.create();
    private RowFilter<BeanTableModel<Object>, Integer> _rowFilter;
    private Set<Object> _allowedValues = new HashSet<Object>();

    public CheckBoxFilterComponent(BeanTableModel<?> beanTableModel, IPropertyContext iPropertyContext) {
        this(beanTableModel, new PropertyContextColumnHandler(iPropertyContext));
    }

    public CheckBoxFilterComponent(BeanTableModel<?> beanTableModel, ColumnHandler<?> columnHandler) {
        this._tableModel = beanTableModel;
        this._column = columnHandler;
        this.setLayout(new BoxLayout(this, 1));
        this._tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CheckBoxFilterComponent.this.refreshCheckBoxes();
            }
        });
        this.refreshCheckBoxes();
        RowFilterX.addFilterToRowSorter(this._tableModel.getRowSorter(), this.getRowFilter());
    }

    /*
     * WARNING - void declaration
     */
    public void refreshCheckBoxes() {
        void var3_6;
        this._values.clear();
        int n = 0;
        for (Object iterator : this._tableModel.getRows()) {
            Object object = this._column.getColumnValue(iterator, n);
            this._values.add(object);
            ++n;
        }
        List list = (List)ObjectX.magicast((Object)ListX.create(this._values));
        Collections.sort(list);
        for (JCheckBox jCheckBox : this._checkBoxes) {
            jCheckBox.setVisible(false);
            jCheckBox.setSelected(false);
        }
        boolean bl = false;
        while (var3_6 < list.size()) {
            JCheckBox jCheckBox;
            Object e = list.get((int)var3_6);
            if (var3_6 < this._checkBoxes.size()) {
                jCheckBox = this._checkBoxes.get((int)var3_6);
            } else {
                final JCheckBox jCheckBox2 = jCheckBox = new JCheckBox();
                jCheckBox.setSelected(true);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = jCheckBox2.isSelected();
                        if ((actionEvent.getModifiers() & 2) != 0) {
                            boolean bl2 = !bl;
                            for (JCheckBox jCheckBox : CheckBoxFilterComponent.this._checkBoxes) {
                                if (jCheckBox == jCheckBox2) continue;
                                jCheckBox.setSelected(bl2);
                                Object object = jCheckBox.getClientProperty("value");
                                if (bl2) {
                                    CheckBoxFilterComponent.this._allowedValues.add(object);
                                    continue;
                                }
                                CheckBoxFilterComponent.this._allowedValues.remove(object);
                            }
                        }
                        Object object = jCheckBox2.getClientProperty("value");
                        if (bl) {
                            CheckBoxFilterComponent.this._allowedValues.add(object);
                        } else {
                            CheckBoxFilterComponent.this._allowedValues.remove(object);
                        }
                        CheckBoxFilterComponent.this.filterChanged();
                    }
                });
                this._allowedValues.add(e);
                this._checkBoxes.add(jCheckBox);
                this.add(jCheckBox);
            }
            jCheckBox.setSelected(this._allowedValues.contains(e));
            jCheckBox.putClientProperty("value", e);
            jCheckBox.setText(e.toString());
            jCheckBox.setVisible(true);
            ++var3_6;
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void filterChanged() {
        this._tableModel.getRowSorter().sort();
    }

    public RowFilter<BeanTableModel<Object>, Integer> getRowFilter() {
        if (this._rowFilter == null) {
            this._rowFilter = new RowFilter<BeanTableModel<Object>, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends BeanTableModel<Object>, ? extends Integer> entry) {
                    Object TRow = CheckBoxFilterComponent.this._tableModel.getRow(entry.getIdentifier());
                    Object object = CheckBoxFilterComponent.this._column.getColumnValue(TRow, entry.getIdentifier());
                    return CheckBoxFilterComponent.this._allowedValues.contains(object);
                }
            };
        }
        return this._rowFilter;
    }

    public boolean isSelected(Object object) {
        return this._allowedValues.contains(object);
    }
}

