/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.model3.lang.Visitor;
import net.model3.swing.EventManager;
import net.model3x.swing.AbstractColumnHandler;
import net.model3x.swing.ButtonCellEditor;
import net.model3x.swing.ButtonCellRenderer;
import net.model3x.swing.table.ColumnFilter;

public class ButtonColumnHandler<T>
extends AbstractColumnHandler<T> {
    EventManager<TableRowActionListener<T>> _eventManager = EventManager.create();
    String _buttonText = "press me";
    ColumnFilter<T> _filter;

    public ButtonColumnHandler(String string) {
        super(string, Object.class);
        this.setColumnType(String.class);
    }

    public void addListener(TableRowActionListener<T> tableRowActionListener) {
        this._eventManager.addListener(tableRowActionListener);
    }

    public void setButtonText(String string) {
        this._buttonText = string;
    }

    @Override
    public TableCellEditor getTableCellEditor() {
        return new ButtonCellEditor(){

            @Override
            protected void fireButtonPushedEvent(int n) {
                ButtonColumnHandler.this.fireButtonPushedEvent(n);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                JButton jButton = (JButton)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                ButtonColumnHandler.this.prepareButton(jButton, jTable, object, bl, true, n, n2);
                return jButton;
            }
        };
    }

    @Override
    public TableCellRenderer getTableCellRenderer() {
        return new ButtonCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JButton jButton = (JButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ButtonColumnHandler.this.prepareButton(jButton, jTable, object, bl, bl2, n, n2);
                return jButton;
            }
        };
    }

    protected void fireButtonPushedEvent(final int n) {
        this._eventManager.safeDispatch(new Visitor<TableRowActionListener<T>>(){

            public void visit(TableRowActionListener<T> tableRowActionListener) {
                tableRowActionListener.actionPerformed(n);
            }
        });
    }

    @Override
    public Boolean isEditable() {
        return true;
    }

    @Override
    public Object getColumnValue(T t, int n) {
        return "";
    }

    protected void prepareButton(JButton jButton, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        jButton.setText(this._buttonText);
    }

    public static interface TableRowActionListener<T> {
        public void actionPerformed(int var1);
    }
}

