/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.PropertyContextColumnHandler;
import net.model3x.swing.RendererFactory;

public class BeanTableModel<TRow>
extends AbstractTableModel
implements IBeanTableModel<TRow> {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final long serialVersionUID = 6705157214332813822L;
    private final List<ColumnHandler<TRow>> _columnHandlers = new ArrayList<ColumnHandler<TRow>>();
    private List<TRow> _rows = ListX.create();
    private TableRowSorter<IBeanTableModel<TRow>> _rowSorter;
    private boolean _defaultColumnEditability = false;
    protected boolean _ignoreToggleSortOrder = false;
    final List<ColumnHandler<TRow>> _allColumns = ListX.create();
    private RowFilter<? super IBeanTableModel<TRow>, ? super Integer> _rowFilter = new RowFilter<IBeanTableModel<TRow>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends IBeanTableModel<TRow>, ? extends Integer> entry) {
            Object TRow = BeanTableModel.this.getRow(entry.getIdentifier());
            int n = 0;
            for (ColumnHandler columnHandler : BeanTableModel.this._columnHandlers) {
                Object object = columnHandler.getColumnValue(TRow, n);
                if (!columnHandler.getFilter().include(object)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    };

    @Override
    public void clearColumns() {
        this._columnHandlers.clear();
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Boolean bl = this.getColumn(n2).isEditable();
        if (bl == null) {
            bl = this._defaultColumnEditability;
        }
        return bl;
    }

    @Override
    public ColumnHandler<TRow> addColumn(PropertyContextable propertyContextable) {
        return this.addColumn(propertyContextable.getContext());
    }

    @Override
    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler) {
        return this.addColumn(columnHandler, -1);
    }

    protected void addAllColumn(ColumnHandler<TRow> columnHandler) {
        if (!this._allColumns.contains(columnHandler)) {
            this._allColumns.add(columnHandler);
        }
    }

    @Override
    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler, int n) {
        this.addAllColumn(columnHandler);
        if (n < 0) {
            this._columnHandlers.add(columnHandler);
        } else {
            this._columnHandlers.add(n, columnHandler);
        }
        this.fireTableStructureChanged();
        return columnHandler;
    }

    public ColumnHandler<TRow> addColumn(IPropertyContext iPropertyContext) {
        return this.addColumn(new PropertyContextColumnHandler(iPropertyContext));
    }

    public void addColumns(List<IPropertyContext> list) {
        for (PropertyContextable propertyContextable : list) {
            this.addColumn(propertyContextable.getContext());
        }
    }

    public void addColumns(Iterable<PropertyContextable> iterable) {
        for (PropertyContextable propertyContextable : iterable) {
            this.addColumn(propertyContextable.getContext());
        }
    }

    @Override
    public boolean removeColumn(ColumnHandler<TRow> columnHandler) {
        boolean bl = this._columnHandlers.remove(columnHandler);
        this.fireTableStructureChanged();
        return bl;
    }

    @Override
    public int getColumnCount() {
        return this._columnHandlers.size();
    }

    @Override
    public ColumnHandler<TRow> getColumn(int n) {
        return this._columnHandlers.get(n);
    }

    @Override
    public int columnIndex(ColumnHandler<TRow> columnHandler) {
        return this._columnHandlers.indexOf(columnHandler);
    }

    @Override
    public int getRowIndex(TRow TRow) {
        return this._rows.indexOf(TRow);
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getColumn(n).getColumnType();
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumn(n).getSingularName();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            ColumnHandler<TRow> columnHandler = this.getColumn(n2);
            columnHandler.setColumnValue(this.getRow(n), n, object);
        }
        catch (Exception exception) {
            logger.warn(new Object[]{"error setting row={} col={} to={}", n, n2, object, exception});
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            ColumnHandler<TRow> columnHandler = this.getColumn(n2);
            Object object = columnHandler.getColumnValue(this.getRow(n), n);
            return object;
        }
        catch (Exception exception) {
            logger.warn((Object)"error getting row={} col={}", (Object)n, (Object)n2, (Object)exception);
            return null;
        }
    }

    @Override
    public TRow getRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.getRows().get(n);
        }
        return null;
    }

    @Override
    public List<? extends TRow> getRows() {
        return this._rows;
    }

    @Override
    public void setRows(List<? extends TRow> list) {
        this._rows = ListX.create(list);
        this.fireTableDataChanged();
    }

    @Override
    public void setLiveRows(EventList<TRow> eventList) {
        this._rows = eventList;
        eventList.addListEventListener(new ListEventListener<TRow>(){

            public void listChanged(ListEvent<TRow> listEvent) {
                BeanTableModel.this.fireTableDataChanged();
            }
        });
        this.fireTableDataChanged();
    }

    @Override
    public TableRowSorter<IBeanTableModel<TRow>> getRowSorter() {
        if (this._rowSorter == null) {
            TableRowSorter tableRowSorter = new TableRowSorter<IBeanTableModel<TRow>>(this){

                @Override
                public void toggleSortOrder(int n) {
                    if (!BeanTableModel.this._ignoreToggleSortOrder) {
                        super.toggleSortOrder(n);
                    }
                }
            };
            Comparator<Comparable<Object>> comparator = new Comparator<Comparable<Object>>(){

                @Override
                public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
                    return comparable.compareTo(comparable2);
                }
            };
            for (int i = 0; i < this._columnHandlers.size(); ++i) {
                tableRowSorter.setComparator(i, comparator);
            }
            this.setRowSorter(tableRowSorter);
        }
        return this._rowSorter;
    }

    public void setRowSorter(TableRowSorter<IBeanTableModel<TRow>> tableRowSorter) {
        tableRowSorter.setRowFilter(this._rowFilter);
        this._rowSorter = tableRowSorter;
    }

    public void setPreferredWidths(TableColumnModel tableColumnModel) {
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            ColumnHandler<TRow> columnHandler = this.getColumn(i);
            if (columnHandler.getPreferredWidth() == null) continue;
            int n = columnHandler.getPreferredWidth() * 8;
            tableColumn.setPreferredWidth(n);
        }
    }

    public void fireRowChanged(Object object) {
        int n = this.getRows().indexOf(object);
        if (n >= 0) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public void removeRow(Object object) {
        int n = this._rows.indexOf(object);
        if (n != -1) {
            this._rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    @Override
    public int addRow(TRow TRow) {
        int n = this.getRowCount();
        this.insertRow(n, TRow);
        return n;
    }

    public void addAllRows(List<TRow> list) {
        for (TRow TRow : list) {
            int n = this.getRowCount();
            this.insertRow(n, TRow);
        }
    }

    public void insertRow(int n, TRow TRow) {
        this._rows.add(n, TRow);
        this.fireTableRowsInserted(n, n);
        this.fireTableDataChanged();
    }

    public void clearAllRows() {
        this._rows.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void initializeDefaultCellRenderers(JTable jTable, RendererFactory rendererFactory) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellEditor tableCellEditor;
            ColumnHandler<TRow> columnHandler = this.getColumn(i);
            TableCellRenderer tableCellRenderer = columnHandler.getTableCellRenderer();
            if (tableCellRenderer == null && rendererFactory != null) {
                tableCellRenderer = rendererFactory.getTableCellRenderer(columnHandler.getColumnType());
            }
            if (tableCellRenderer != null) {
                jTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
            }
            if ((tableCellEditor = columnHandler.getTableCellEditor()) == null && rendererFactory != null) {
                tableCellEditor = rendererFactory.getTableCellEditor(columnHandler.getColumnType());
            }
            if (tableCellEditor == null) continue;
            jTable.getColumnModel().getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    @Override
    public List<ColumnHandler<TRow>> getAllColumns() {
        return this._allColumns;
    }

    @Override
    public List<ColumnHandler<TRow>> getColumns() {
        return this._columnHandlers;
    }

    public void setColumns(List<ColumnHandler<TRow>> list) {
        this.clearColumns();
        for (ColumnHandler<TRow> columnHandler : list) {
            this.addColumn(columnHandler);
        }
    }

    public boolean hasRow(TRow TRow) {
        return this._rows.contains(TRow);
    }

    @Override
    public void setIgnoreToggleSortOrder(boolean bl) {
        this._ignoreToggleSortOrder = bl;
    }

    public static <T> void addColumns(IBeanTableModel<T> iBeanTableModel, Iterable<IPropertyContext> iterable) {
        for (PropertyContextable propertyContextable : iterable) {
            iBeanTableModel.addColumn(new PropertyContextColumnHandler(propertyContextable.getContext()));
        }
    }
}

