/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.datafeed;

import ca.odell.glazedlists.EventList;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.datafeed.Index;

public class UniqueIndex<T> {
    Map<Index, T> _indexMap = MapX.create();
    Map<Object, Index> _identityMap = MapX.create();
    DataFeedListener<T> _indexListener;
    Class<T> _type;
    List<IPropertyContext> _keyFields = ListX.create();

    public UniqueIndex(DataFeedService dataFeedService, PropertyContextable ... propertyContextableArray) {
        for (PropertyContextable propertyContextable : propertyContextableArray) {
            this._keyFields.add(propertyContextable.getContext());
        }
        this._type = propertyContextableArray[0].getContext().getParentBeanContext().getType();
        this.registerIndex(dataFeedService);
    }

    public Index createIndex(T t) {
        Object[] objectArray = new Object[this._keyFields.size()];
        int n = 0;
        for (IPropertyContext iPropertyContext : this._keyFields) {
            objectArray[n] = iPropertyContext.getValue(t);
            ++n;
        }
        return new Index(objectArray);
    }

    public void addAll(Iterable<T> iterable) {
        for (T t : iterable) {
            this.add(t);
        }
    }

    public void remove(T t) {
        Index index = this._identityMap.get(t);
        if (index != null) {
            this._indexMap.remove(index);
        }
    }

    public void add(T t) {
        Index index = this._identityMap.get(t);
        Index index2 = this.createIndex(t);
        if (index != null && index.equals(index2)) {
            return;
        }
        if (index != null) {
            this._indexMap.remove(index);
        }
        this._indexMap.put(index2, t);
    }

    Class<T> getType() {
        return this._type;
    }

    public void registerIndex(DataFeedService dataFeedService) {
        Class<T> clazz = this.getType();
        this._indexListener = dataFeedService.registerDataFeed(clazz, new DataFeedListener<T>(){

            @Override
            public void newBeanList(EventList<T> eventList) {
                UniqueIndex.this.addAll(eventList);
            }

            @Override
            public void beanChanged(T t) {
                UniqueIndex.this.add(t);
            }

            @Override
            public void beanAdded(T t) {
                UniqueIndex.this.add(t);
            }

            @Override
            public void beanRemoved(T t) {
                UniqueIndex.this.remove(t);
            }
        });
    }

    public T fetch(Object ... objectArray) {
        return (T)this.fetch((T)new Index(objectArray));
    }

    protected T fetch(Index index) {
        return this._indexMap.get(index);
    }

    public T fetch(T t) {
        return (T)this.fetch((T)this.createIndex(t));
    }
}

