/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.datafeed;

import ca.odell.glazedlists.EventList;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.GeneratedMap;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.lang.ClassX;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.datafeed.Index;

public class GroupingIndex<T> {
    Map<Index, NavigableSet<T>> _indexMap = new GeneratedMap<Index, NavigableSet<T>>(){

        public NavigableSet<T> generate(Index index) {
            if (GroupingIndex.this._comparator == null) {
                return new TreeSet();
            }
            return new TreeSet(GroupingIndex.this._comparator);
        }
    };
    Map<Object, Index> _identityMap = MapX.create();
    DataFeedListener<T> _dataFeedListener = new DataFeedListener<T>(){

        @Override
        public void newBeanList(EventList<T> eventList) {
            GroupingIndex.this.clear();
            GroupingIndex.this.addAll(eventList);
        }

        @Override
        public void beanChanged(T t) {
            GroupingIndex.this.add(t);
        }

        @Override
        public void beanAdded(T t) {
            GroupingIndex.this.add(t);
        }

        @Override
        public void beanRemoved(T t) {
            GroupingIndex.this.remove(t);
        }
    };
    Class<T> _type;
    Comparator<T> _comparator;
    List<IPropertyContext> _groupingFields;
    Predicate<T> _filter = Predicates.alwaysTrue();

    protected GroupingIndex(DataFeedService dataFeedService, Predicate<T> predicate, PropertyContextable ... propertyContextableArray) {
        if (propertyContextableArray.length == 0) {
            propertyContextableArray = new PropertyContextable[]{BeanContainer.get().getContext(this.getType()).getProperty("uuid")};
        }
        this._type = ClassX.getParameterizedType(this.getClass());
        this._comparator = BeanComparator.create((PropertyContextable[])propertyContextableArray);
        this._filter = predicate;
        this.registerIndex(dataFeedService);
    }

    public GroupingIndex(DataFeedService dataFeedService, Predicate<T> predicate, PropertyContextable[] propertyContextableArray, PropertyContextable[] propertyContextableArray2) {
        this._filter = predicate;
        if (this._filter == null) {
            this._filter = Predicates.alwaysTrue();
        }
        this._type = propertyContextableArray.length > 0 ? propertyContextableArray[0].getContext().getParentBeanContext().getType() : propertyContextableArray2[0].getContext().getParentBeanContext().getType();
        if (propertyContextableArray.length == 0) {
            propertyContextableArray = new PropertyContextable[]{BeanContainer.get().getContext(this.getType()).getProperty("uuid")};
        }
        this._comparator = BeanComparator.create((PropertyContextable[])propertyContextableArray);
        this._groupingFields = ListX.create();
        for (PropertyContextable propertyContextable : propertyContextableArray2) {
            this._groupingFields.add(propertyContextable.getContext());
        }
        this.registerIndex(dataFeedService);
    }

    public GroupingIndex(DataFeedService dataFeedService, PropertyContextable[] propertyContextableArray, PropertyContextable[] propertyContextableArray2) {
        this(dataFeedService, (Predicate<T>)null, propertyContextableArray, propertyContextableArray2);
    }

    public void setFilter(Predicate<T> predicate) {
        this._filter = predicate;
    }

    public Index createIndex(T t) {
        Object[] objectArray = new Object[this._groupingFields.size()];
        int n = 0;
        for (IPropertyContext iPropertyContext : this._groupingFields) {
            objectArray[n] = iPropertyContext.getValue(t);
            ++n;
        }
        return new Index(objectArray);
    }

    public void addAll(Iterable<T> iterable) {
        for (T t : iterable) {
            this.add(t);
        }
    }

    void clear() {
        this._indexMap.clear();
        this._identityMap.clear();
    }

    public void remove(T t) {
        Index index = this._identityMap.get(t);
        if (index != null) {
            SortedSet sortedSet = this._indexMap.get(index);
            sortedSet.remove(t);
            this._identityMap.remove(t);
            if (sortedSet.size() == 0) {
                this._indexMap.remove(index);
            }
        }
    }

    public void add(T t) {
        Index index = this._identityMap.get(t);
        boolean bl = this._filter.apply(t);
        if (index == null && !bl) {
            return;
        }
        Index index2 = this.createIndex(t);
        if (index != null && index.equals(index2) && bl) {
            return;
        }
        if (index != null) {
            SortedSet sortedSet = this._indexMap.get(index);
            sortedSet.remove(t);
            if (sortedSet.size() == 0) {
                this._indexMap.remove(index);
            }
        }
        if (bl) {
            this._indexMap.get(index2).add(t);
            this._identityMap.put(t, index2);
        } else {
            this._identityMap.remove(t);
        }
    }

    Class<T> getType() {
        return this._type;
    }

    public void registerIndex(DataFeedService dataFeedService) {
        dataFeedService.registerDataFeed(this.getType(), this._dataFeedListener);
    }

    public NavigableSet<T> fetch(Object ... objectArray) {
        return this.fetch((T)new Index(objectArray));
    }

    protected NavigableSet<T> fetch(Index index) {
        if (this._indexMap.containsKey(index)) {
            return this._indexMap.get(index);
        }
        return SetX.emptyNavigableSet();
    }

    public NavigableSet<T> fetch(T t) {
        return this.fetch((T)this.createIndex(t));
    }
}

