/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.datafeed;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.Matcher;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Session;
import net.model3.collections.GeneratedMap;
import net.model3.lang.Visitor;
import net.model3.swing.EventManager;
import net.model3x.datafeed.DataFeedListener;
import net.model3x.datafeed.DataFeedService;
import net.model3x.swing.IBeanTableModel;

@Singleton
public class DataFeedServiceImpl
implements DataFeedService {
    Map<Class<?>, EventManager<DataFeedListener<?>>> _dataFeedMap = new GeneratedMap<Class<?>, EventManager<DataFeedListener<?>>>(){

        public EventManager<DataFeedListener<?>> generate(Class<?> clazz) {
            return EventManager.create((boolean)true);
        }
    };
    ConcurrentHashMap<Class<?>, EventList<?>> _lists = new ConcurrentHashMap();

    @Override
    public <T> DataFeedListener<T> registerDataFeed(Class<T> clazz, DataFeedListener<T> dataFeedListener) {
        this._dataFeedMap.get(clazz).addListener(dataFeedListener);
        EventList<T> eventList = this.getDataFeed(clazz);
        if (eventList != null) {
            dataFeedListener.newBeanList(eventList);
        }
        return dataFeedListener;
    }

    @Override
    public void createDataFeed(Class<?> clazz) {
        this._lists.putIfAbsent(clazz, (EventList<?>)new BasicEventList());
    }

    @Override
    public boolean hasDataFeed(Class<?> clazz) {
        return this._lists.containsKey(clazz);
    }

    @Override
    public void fireBeanInserted(final Object object) {
        EventList<?> eventList = this.getDataFeed(object.getClass());
        if (eventList != null) {
            eventList.getReadWriteLock().writeLock().lock();
            try {
                eventList.add(object);
                this._dataFeedMap.get(object.getClass()).safeDispatch(new Visitor<DataFeedListener<?>>(){

                    public void visit(DataFeedListener<?> dataFeedListener) {
                        dataFeedListener.beanAdded(object);
                    }
                });
            }
            finally {
                eventList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @Override
    public void fireBeanUpdated(final Object object) {
        EventList<?> eventList = this.getDataFeed(object.getClass());
        if (eventList != null) {
            eventList.getReadWriteLock().writeLock().lock();
            try {
                eventList.set(eventList.indexOf(object), object);
                this._dataFeedMap.get(object.getClass()).safeDispatch(new Visitor<DataFeedListener<?>>(){

                    public void visit(DataFeedListener<?> dataFeedListener) {
                        dataFeedListener.beanChanged(object);
                    }
                });
            }
            finally {
                eventList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @Override
    public void fireBeanDeleted(final Object object) {
        EventList<?> eventList = this.getDataFeed(object.getClass());
        if (eventList != null) {
            eventList.remove(object);
            this._dataFeedMap.get(object.getClass()).safeDispatch(new Visitor<DataFeedListener<?>>(){

                public void visit(DataFeedListener<?> dataFeedListener) {
                    dataFeedListener.beanRemoved(object);
                }
            });
        }
    }

    @Override
    public <T> DataFeedListener<T> attachTableModelToDataFeed(Class<T> clazz, final IBeanTableModel<T> iBeanTableModel) {
        return this.registerDataFeed(clazz, new DataFeedListener<T>(){

            @Override
            public void newBeanList(EventList<T> eventList) {
                iBeanTableModel.setRows(eventList);
            }

            @Override
            public void beanChanged(T t) {
                int n = iBeanTableModel.getRowIndex(t);
                if (n >= 0) {
                    Object TRow = iBeanTableModel.getRow(n);
                    if (t != TRow) {
                        for (IPropertyContext iPropertyContext : BeanContainer.get().getContext(t).getProperties()) {
                            if (!iPropertyContext.isWritable()) continue;
                            Object object = iPropertyContext.getValue(t);
                            iPropertyContext.setValue(TRow, object);
                        }
                    }
                    iBeanTableModel.fireTableRowsUpdated(n, n);
                }
            }

            @Override
            public void beanAdded(T t) {
                int n = iBeanTableModel.getRowIndex(t);
                if (n == -1) {
                    iBeanTableModel.addRow(t);
                }
            }

            @Override
            public void beanRemoved(T t) {
                iBeanTableModel.removeRow(t);
            }
        });
    }

    @Override
    public <T> void fireNewIndex(Class<T> clazz, final EventList<T> eventList) {
        this._dataFeedMap.get(clazz).safeDispatch(new Visitor<DataFeedListener<?>>(){

            public void visit(DataFeedListener<?> dataFeedListener) {
                dataFeedListener.newBeanList(eventList);
            }
        });
    }

    @Override
    public void delete(Object object) {
        CurrentSession.get().delete(object);
    }

    @Override
    public void save(Object object) {
        Session session = CurrentSession.get();
        if (session.isPersisted(object)) {
            session.update(object);
        } else {
            session.insert(object);
        }
        CurrentSession.get().commit();
    }

    public <T> FilterList<T> filteredFeed(Class<T> clazz, Matcher<T> matcher) {
        EventList<T> eventList = this.getDataFeed(clazz, true);
        return new FilterList(eventList, matcher);
    }

    @Override
    public <T> EventList<T> getDataFeed(Class<T> clazz) {
        return this.getDataFeed(clazz, false);
    }

    @Override
    public <T> EventList<T> getDataFeed(Class<T> clazz, boolean bl) {
        if (bl && !this._lists.containsKey(clazz)) {
            this.createDataFeed(clazz);
        }
        return this._lists.get(clazz);
    }
}

