/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.cache;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.model3.chrono.DateOnly;
import net.model3.lang.ByteSize;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3x.cache.FileComparator;

public class CacheCleaner
implements Runnable {
    private static final Log logger = LogHelper.getLog(CacheCleaner.class);
    private Directory directory;
    private ByteSize byteSize;
    private boolean deleteEmptyDirectories;
    private DateOnly deletePriorToDate;
    private FileComparator fileComparator;
    private File historyFile;
    private int hoursBetweenExecution = 24;

    public CacheCleaner(File file, Directory directory, ByteSize byteSize, boolean bl, DateOnly dateOnly) {
        this.directory = directory;
        this.byteSize = byteSize;
        this.deleteEmptyDirectories = bl;
        this.deletePriorToDate = dateOnly;
        this.historyFile = file;
    }

    public void setFileComparator(FileComparator fileComparator) {
        this.fileComparator = fileComparator;
    }

    public void setHoursBetweenExecution(int n) {
        this.hoursBetweenExecution = n;
    }

    @Override
    public void run() {
        long l;
        Object object;
        logger.debug((Object)"Cache cleaner running on path {}", (Object)this.directory.getPath());
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.historyFile.asFile()));
            object = properties.getProperty(this.directory.getName());
            if (object != null && ((String)object).length() > 0) {
                l = Long.valueOf((String)object);
                long l2 = 3600000 * this.hoursBetweenExecution;
                if (l2 < System.currentTimeMillis() - l2) {
                    return;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn((Object)"run history file not found. proceeding with cleaning...");
        }
        catch (Exception exception) {
            logger.warn((Object)"failed to load the run history file. proceeding with cleaning...", (Object)exception);
        }
        if (this.directory == null || !this.directory.exists()) {
            logger.warn((Object)"directory {} not found", (Object)this.directory);
        } else {
            object = this.directory.filesRecursive();
            l = this.getDirectorySizeInBytes((List<File>)object);
            logger.trace((Object)"Path: {} -- Max size: {} -- Actual Size: {}", (Object)this.directory.getPath(), (Object)this.byteSize.asAbbreviatedText(), (Object)new ByteSize(l).asAbbreviatedText());
            if (l > this.byteSize.inBytes()) {
                logger.debug((Object)"Cache cleaner needs to clean path {}", (Object)this.directory.getPath());
                if (this.fileComparator == null) {
                    this.fileComparator = new DefaultFileComparator();
                }
                Collections.sort(object, this.fileComparator);
                int n = 0;
                while (l > this.byteSize.inBytes() && object.get(n) != null) {
                    l -= ((File)object.get(n)).length();
                    ((File)object.get(n)).delete();
                    ++n;
                }
                logger.debug((Object)"Cache cleaner has finished cleaning path {}", (Object)this.directory.getPath());
                logger.debug((Object)"Delete empty directories? {}", (Object)this.deleteEmptyDirectories);
                if (this.deleteEmptyDirectories) {
                    List list = this.directory.subDirectoriesRecursive();
                    for (Directory directory : list) {
                        if (directory.filesRecursive().size() == 0) {
                            directory.deleteTree();
                            continue;
                        }
                        System.out.println(String.format("dir %s has %s files remaining", directory.getName(), directory.filesRecursive().size()));
                    }
                    logger.debug((Object)"Deleted empty directories");
                }
            }
        }
        properties.setProperty(this.directory.getName(), "" + System.currentTimeMillis());
        try {
            properties.store(new FileOutputStream(this.historyFile.asFile()), "Completed execution on directory " + this.directory.getName());
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to update directory cleaning history on directory " + this.directory.getName()), (Object)exception);
        }
    }

    public long getDirectorySizeInBytes(List<File> list) {
        long l = 0L;
        for (File file : list) {
            if (this.deletePriorToDate != null && this.fileComparator.isFileOlderThan(file, this.deletePriorToDate)) {
                file.delete();
                continue;
            }
            l += file.length();
        }
        return l;
    }

    private class DefaultFileComparator
    implements FileComparator {
        private DefaultFileComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            if (file == null && file2 == null) {
                return 0;
            }
            if (file2 == null) {
                return 1;
            }
            if (file == null) {
                return -1;
            }
            if (file.getLastModified().after(file2.getLastModified())) {
                return 1;
            }
            if (file.getLastModified().before(file2.getLastModified())) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean isFileOlderThan(File file, DateOnly dateOnly) {
            return file.getLastModified().inMillis() < dateOnly.asDate().getTime();
        }
    }
}

