/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.beanprops.orm;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Session;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.servlet.AbstractHttpFilter;

@Singleton
public class TransactionFilter
extends AbstractHttpFilter {
    private static final Log logger = LogHelper.getLog();

    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Session session;
        try {
            session = CurrentSession.get((boolean)false);
            if (session != null) {
                logger.warn((Object)"closing lingering session{}", (Object)session);
                session.close();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"error closing lingering session", (Object)exception);
        }
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            session = CurrentSession.get((boolean)false);
            if (session != null) {
                session.commit();
            }
        }
        catch (Exception exception) {
            Session session2 = CurrentSession.get((boolean)false);
            if (session2 != null) {
                try {
                    logger.error((Object)"error processing request connection will be rolled back", (Object)exception);
                    session2.getConnection().rollback();
                }
                catch (Exception exception2) {
                    logger.error((Object)"error rolling back connection", (Object)exception2);
                }
            }
            throw ExceptionPropagator.wrapServletException((Throwable)exception);
        }
        finally {
            try {
                Session session3 = CurrentSession.get((boolean)false);
                if (session3 != null) {
                    session3.close();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"error closing session", (Object)exception);
            }
        }
    }
}

