/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.beanprops.orm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class TimeDurationAsStringHandler
extends SingleColumnHandler<TimeDuration> {
    private static final Logger logger = LoggerHelper.getLogger();

    public Integer getSqlTypeAsInteger() {
        return 12;
    }

    protected boolean autoHandleNulls() {
        return true;
    }

    public void mapColumnValueToPreparedStatement(TimeDuration timeDuration, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, timeDuration.toString());
    }

    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(TimeDuration.class);
    }

    public void loadProperty(WProperty<TimeDuration> wProperty, ResultSet resultSet, int n) throws SQLException {
        TimeDuration timeDuration;
        String string = resultSet.getString(n);
        try {
            timeDuration = string == null ? null : new TimeDuration(string);
        }
        catch (Exception exception) {
            logger.warn((Object)"invalid time duration string {} returning null", (Object)string);
            timeDuration = null;
        }
        wProperty.set((Object)timeDuration);
    }
}

