/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.beanprops.orm;

import com.google.inject.Inject;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.dialect.SQLDialect;
import net.java.dev.properties.jdbc.handlers.TableCreator;
import net.java.dev.properties.jdbc.handlers.TableDropper;
import net.model3.collections.ListX;
import net.model3.io.IOHelper;
import net.model3.jdbc.JdbcHelper;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.StringJoiner;
import net.model3x.beanprops.orm.SchemaVersion;
import net.model3x.tx.CommandLineToolAdapter;
import net.model3x.tx.ToolRunner;

public class CreateDatabase
extends CommandLineToolAdapter {
    private static final Logger logger = LoggerHelper.getLogger();
    @Inject
    private SchemaVersion _schemaVersion;
    @Inject
    private SessionConfiguration _sessionConfiguration;
    @Inject
    private Connection _connection;

    public static void main(String[] stringArray) throws Exception {
        ToolRunner.start();
    }

    @Override
    public void run() {
        try {
            TableCreator tableCreator;
            Map map = this._sessionConfiguration.getTableCreators();
            List list = ListX.create(map.keySet());
            for (String string : list) {
                tableCreator = (TableCreator)map.get(string);
                if (tableCreator instanceof TableDropper) {
                    ((TableDropper)tableCreator).dropTable();
                    continue;
                }
                if (tableCreator == null) continue;
                try {
                    SQLDialect sQLDialect = this._sessionConfiguration.getSqlDialect();
                    String string2 = sQLDialect.getDropTableSql(tableCreator.getTableName(), sQLDialect.supportsIfExistsOnDropTable());
                    this.executeUpdateQuery(string2, new Object[0]);
                }
                catch (Exception exception) {}
            }
            for (String string : list) {
                tableCreator = (TableCreator)map.get(string);
                if (tableCreator != null) {
                    ((TableCreator)map.get(string)).createTable();
                    continue;
                }
                logger.warn((Object)"unable to create table {}.  No table creator found", (Object)string);
            }
            for (String string : CreateDatabase.getSqlStatementsFromScriptFile("create_database.sql")) {
                this.executeUpdateQuery(string, new Object[0]);
            }
            String string = "insert into system_values (name, value) values( 'schema_version', '" + this._schemaVersion.getExpectedVersion() + "' )";
            this.executeUpdateQuery(string, new Object[0]);
            if (!this._connection.getAutoCommit()) {
                this._connection.commit();
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            try {
                this._connection.rollback();
            }
            catch (Exception exception2) {
                logger.error((Object)"error performaing rollback", (Object)exception);
            }
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
        finally {
            JdbcHelper.close((Connection)this._connection);
        }
    }

    void executeUpdateQuery(String string, Object ... objectArray) {
        UpdateQuery updateQuery = new UpdateQuery(string);
        updateQuery.setConnection(this._connection);
        updateQuery.setArguments(objectArray);
        updateQuery.execute();
    }

    static List<String> getSqlStatementsFromScriptFile(String string) {
        List list = IOHelper.readLines((InputStream)ClassX.getResourceAsStream((String)string));
        ArrayList<String> arrayList = new ArrayList<String>();
        List list2 = ListX.create();
        for (String string2 : list) {
            if (string2.startsWith("#") || StringX.isBlank((String)string2)) continue;
            list2.add(string2);
            if (!string2.trim().endsWith(";")) continue;
            arrayList.add(new StringJoiner((Iterable)list2, "\n").toString());
            list2 = ListX.create();
        }
        return arrayList;
    }
}

