/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.beanprops;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.BeanComparator;
import net.java.dev.properties.util.LazyPropertyContext;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.beanprops.DefaultBeanViewsFactory;
import net.model3x.swing.beanprops.TableViewDefinition;
import net.model3x.swing.beanprops.form.FormDefinition;

public class BeanPropsHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    public static final int hashCode(RProperty<?> rProperty) {
        Object object = rProperty.get();
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public static final <T> List<T> createSortedList(Collection<T> collection, PropertyContextable ... propertyContextableArray) {
        List list = ListX.create(collection);
        BeanComparator beanComparator = BeanComparator.create((PropertyContextable[])propertyContextableArray);
        Collections.sort(list, beanComparator);
        return list;
    }

    public static void setNullText(Class<?> clazz, String string) {
        BeanContainer.get().getContext(clazz).setAttribute("null-text", (Object)string);
    }

    public static String getNullText(Class<?> clazz) {
        String string = (String)BeanContainer.get().getContext(clazz).getAttribute("null-text");
        if (string == null) {
            return "";
        }
        return string;
    }

    public static void setTableViewDefinition(IBeanContext iBeanContext, List<IPropertyContext> list) {
        iBeanContext.setAttribute(DefaultBeanViewsFactory.KeyTableViewDefinition, (Object)new TableViewDefinition(iBeanContext.getType(), list));
    }

    public static void setTableViewDefinition(IPropertyContext iPropertyContext, List<IPropertyContext> list) {
        iPropertyContext.setAttribute(DefaultBeanViewsFactory.KeyTableViewDefinition, (Object)new TableViewDefinition(list.get(0).getParentBeanContext().getType(), list));
    }

    public static void setFormDefinition(IBeanContext iBeanContext, FormDefinition formDefinition) {
        iBeanContext.setAttribute(DefaultBeanViewsFactory.KeyFormDefinition, (Object)formDefinition);
    }

    public static FormDefinition getFormDefinition(IBeanContext iBeanContext) {
        return (FormDefinition)iBeanContext.getAttribute(DefaultBeanViewsFactory.KeyFormDefinition);
    }

    public static void setFormDefinition(IPropertyContext iPropertyContext, FormDefinition formDefinition) {
        iPropertyContext.setAttribute(DefaultBeanViewsFactory.KeyFormDefinition, (Object)formDefinition);
    }

    public static IPropertyContext getProperty(IBeanContext iBeanContext, String string) {
        return new LazyPropertyContext(iBeanContext, string);
    }

    static {
        logger.toString();
    }
}

