/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.model3.launcher.util.BytesBuilder;

public final class UrlX {
    private static final Logger logger = Logger.getLogger(UrlX.class.getName());
    private static final char PATH_SEP = '/';
    public static final String PATH_SEP_STRING = "/";
    private URL canonicalUrl_;
    private String canonicalUrlAsString_;
    private UrlX parentUrl_;
    private boolean directory_;
    private Map<String, String> _parms;

    public UrlX(URL uRL) {
        this.init(uRL, false);
    }

    public UrlX(String string) {
        try {
            this.init(new URL(string), false);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public UrlX(UrlX urlX, String string) {
        this(urlX + PATH_SEP_STRING + string);
    }

    private UrlX(URL uRL, boolean bl) {
        this.init(uRL, bl);
    }

    private void init(URL uRL, boolean bl) {
        this.canonicalUrl_ = bl ? uRL : UrlX.resolveToCanonicalUrl(uRL);
        this.canonicalUrlAsString_ = this.canonicalUrl_.toExternalForm();
        this.directory_ = this.canonicalUrlAsString_.endsWith(PATH_SEP_STRING);
    }

    public UrlX getRootUrl() {
        try {
            return new UrlX(new URL(this.canonicalUrl_.getProtocol(), this.canonicalUrl_.getHost(), this.canonicalUrl_.getPort(), PATH_SEP_STRING), true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public UrlX getParentUrl() {
        return this.getParentUrl(false);
    }

    public int getDepthTo(UrlX urlX) {
        String string = this.getPathRelativeTo(urlX);
        return UrlX.countOccurences(string, PATH_SEP_STRING);
    }

    public String getPathRelativeTo(UrlX urlX) {
        if (urlX.canonicalUrlAsString_.equals(this.canonicalUrlAsString_)) {
            return "";
        }
        if (!this.canonicalUrlAsString_.startsWith(urlX.canonicalUrlAsString_)) {
            throw new RuntimeException(urlX + "  is not a parent of " + this);
        }
        int n = urlX.canonicalUrlAsString_.length();
        if (!urlX.isDirectory()) {
            ++n;
        }
        String string = this.canonicalUrlAsString_.substring(n);
        return string;
    }

    public UrlX resolveHref(String string) {
        try {
            URL uRL;
            if (string.startsWith("javascript:")) {
                return null;
            }
            if (string.indexOf(":") > 0) {
                uRL = new URL(string);
            } else {
                UrlX urlX = string.startsWith(PATH_SEP_STRING) ? this.getRootUrl() : this.getParentUrl(true);
                uRL = new URL(urlX + PATH_SEP_STRING + string);
            }
            return new UrlX(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.FINE, "malformed url resolving href=" + string + "    page=" + this.canonicalUrlAsString_, malformedURLException);
            return null;
        }
    }

    public UrlX getParentUrl(boolean bl) {
        if (bl && this.directory_) {
            return this;
        }
        if (this.parentUrl_ == null) {
            String string = this.canonicalUrl_.getPath();
            int n = string.length();
            if (this.directory_) {
                if (n == 1 || string.equals(PATH_SEP_STRING)) {
                    return null;
                }
                n -= 2;
            }
            int n2 = string.lastIndexOf(47, n);
            String string2 = string.substring(0, n2 + 1);
            try {
                this.parentUrl_ = new UrlX(new URL(this.canonicalUrl_.getProtocol(), this.canonicalUrl_.getHost(), this.canonicalUrl_.getPort(), string2), true);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this.parentUrl_;
    }

    public UrlX findCommonParent(UrlX urlX) {
        for (UrlX urlX2 = urlX; urlX2 != null; urlX2 = urlX2.getParentUrl()) {
            if (!this.canonicalUrlAsString_.startsWith(urlX2.canonicalUrlAsString_)) continue;
            return urlX2;
        }
        return null;
    }

    public boolean isDirectory() {
        return this.directory_;
    }

    public String toString() {
        return this.canonicalUrlAsString_;
    }

    public static URL resolveToCanonicalUrl(URL uRL) {
        String string = uRL.getPath();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(PATH_SEP_STRING)) {
            if (string2.length() == 0 || string2.equals(".")) continue;
            if (string2.equals("..")) {
                if (arrayList.isEmpty()) {
                    bl = true;
                    continue;
                }
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append('/');
            stringBuilder.append((String)iterator.next());
        }
        if (arrayList.isEmpty() || string.endsWith(PATH_SEP_STRING)) {
            stringBuilder.append('/');
        }
        if (uRL.getQuery() != null) {
            stringBuilder.append("?");
            stringBuilder.append(uRL.getQuery());
        }
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), stringBuilder.toString());
            if (bl) {
                logger.log(Level.WARNING, "poorly formed URL " + uRL.toString() + "  canonicalized to " + uRL2.toString());
            }
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public boolean equals(Object object) {
        UrlX urlX = (UrlX)object;
        return urlX.canonicalUrlAsString_.equals(this.canonicalUrlAsString_);
    }

    public int hashCode() {
        int n = 5;
        n = 31 * n + (this.canonicalUrlAsString_ != null ? this.canonicalUrlAsString_.hashCode() : 0);
        return n;
    }

    public URL asUrl() {
        return this.canonicalUrl_;
    }

    public String asString() {
        return this.toString();
    }

    public String getRelativeHref(UrlX urlX) {
        UrlX urlX2 = this.findCommonParent(urlX);
        if (urlX2 != null) {
            int n = this.getDepthTo(urlX2);
            String string = urlX.getPathRelativeTo(urlX2);
            StringBuffer stringBuffer = new StringBuffer();
            UrlX.appendRepeat(stringBuffer, "../", n);
            stringBuffer.append(string);
            if (stringBuffer.length() == 0) {
                stringBuffer.append("./");
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        return null;
    }

    private BytesBuilder downloadAsBytesBuilder() {
        return this.downloadAsBytesBuilder(null);
    }

    public BytesBuilder downloadAsBytesBuilder(BytesBuilder.DownloadListener downloadListener) {
        long l = System.currentTimeMillis();
        logger.fine("starting download of " + this);
        BytesBuilder bytesBuilder = new BytesBuilder(this.openStream(), downloadListener);
        long l2 = System.currentTimeMillis() - l;
        long l3 = bytesBuilder.getByteCount();
        logger.fine("download of " + this + " " + l3 + "bytes completed in " + l2 + "ms");
        return bytesBuilder;
    }

    public String getContentAsString() {
        return this.downloadAsBytesBuilder().asString();
    }

    public byte[] getContentAsBytes() {
        return this.downloadAsBytesBuilder().asBytes();
    }

    public InputStream openStream() {
        try {
            return this.canonicalUrl_.openStream();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isParentOf(UrlX urlX) {
        return urlX.canonicalUrlAsString_.startsWith(this.canonicalUrlAsString_);
    }

    public boolean isFileProtocol() {
        return this.asString().startsWith("file:");
    }

    public String getHostnameFromUrl() {
        int n = this.canonicalUrlAsString_.indexOf("//");
        if (n < 0) {
            return null;
        }
        int n2 = this.canonicalUrlAsString_.indexOf(PATH_SEP_STRING, n + 2);
        int n3 = this.canonicalUrlAsString_.indexOf(":", n + 2);
        String string = n3 >= 0 && (n2 < 0 || n3 < n2) ? this.canonicalUrlAsString_.substring(n + 2, n3) : (n2 > 0 ? this.canonicalUrlAsString_.substring(n + 2, n2) : this.canonicalUrlAsString_.substring(n + 2));
        return string;
    }

    public String getFilenamePart() {
        return this.getPathRelativeTo(this.getParentUrl());
    }

    public Map<String, String> getParms() {
        if (this._parms == null) {
            String string = this.canonicalUrl_.getQuery();
            logger.fine(String.format("getParms determined the query to be: %s", string));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : string.split("&")) {
                String[] stringArray = string2.split("=");
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this._parms = hashMap;
        }
        return this._parms;
    }

    public static URI toURI(URL uRL) {
        try {
            return new URI(uRL.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    static int countOccurences(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n = string.indexOf(string2, n3)) < 0) {
                return n2;
            }
            ++n2;
        } while ((n3 = n + string2.length()) <= string.length());
        return n2;
    }

    static void appendRepeat(StringBuffer stringBuffer, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
    }
}

