/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.util;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.model3.launcher.util.LogFormatter;

public class TimestampedFileHandler
extends StreamHandler {
    public static final String TIMESTAMP_DATE_FORMAT = "yyyy-MM-dd-EEE_HH-mm-ss";
    private static Pattern _timestampRegex = Pattern.compile("([\\d]{4}-[\\d]{2}-[\\d]{2}-[\\w]{3}_[\\d]{2}-[\\d]{2}-[\\d]{2})");
    private File _archiveDir;
    private File _logDir;
    private File _file;
    private String _filenamePrefix;
    private String _filenameSuffix;

    public TimestampedFileHandler(File file, File file2, String string, String string2) {
        try {
            this._logDir = file;
            this._archiveDir = file2;
            this._filenamePrefix = string;
            this._filenameSuffix = string2;
            this._file = new File(file, string + TimestampedFileHandler.getTimestampStringForNow() + string2);
            this.setOutputStream(new FileOutputStream(this._file));
            this.setFormatter(new LogFormatter());
            file.mkdirs();
            file2.mkdirs();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    TimestampedFileHandler.rollLogfiles(TimestampedFileHandler.this._logDir, TimestampedFileHandler.this._archiveDir, TimestampedFileHandler.this._filenamePrefix, TimestampedFileHandler.this._filenameSuffix);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public static String getTimestampStringForNow() {
        return new SimpleDateFormat(TIMESTAMP_DATE_FORMAT).format(new Date());
    }

    public static Date getTimestampedFromFilename(String string) {
        Matcher matcher = _timestampRegex.matcher(string);
        if (matcher.find()) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIMESTAMP_DATE_FORMAT);
                return simpleDateFormat.parse(matcher.group());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static void rollLogfiles(File file, File file2, String string, String string2) {
        TimestampedFileHandler.moveToArchiveDirectory(file, file2, string, string2);
        TimestampedFileHandler.purgeArchiveDirectory(file2);
    }

    static void moveToArchiveDirectory(File file, File file2, String string, String string2) {
        for (File file3 : file.listFiles()) {
            if (file3.getName().startsWith(string) && file3.getName().endsWith(string2)) {
                file3.renameTo(new File(file2, file3.getName()));
            }
            if (!file3.getName().endsWith(".lck")) continue;
            file3.delete();
        }
    }

    static void purgeArchiveDirectory(File file) {
        Date date = TimestampedFileHandler.getPastDay(7);
        for (File file2 : file.listFiles()) {
            Date date2 = TimestampedFileHandler.getTimestampedFromFilename(file2.getName());
            if (date2 == null || !date2.before(date)) continue;
            file2.delete();
        }
    }

    static Date getPastDay(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(5, -n);
        return gregorianCalendar.getTime();
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (logRecord.getLoggerName().startsWith("sun.")) {
            return;
        }
        super.publish(logRecord);
        this.flush();
    }
}

