/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class Model3Helpers {
    public static boolean isWindows() {
        return System.getProperty("os.name", "").contains("Windows");
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            switch (string.length()) {
                case 1: {
                    string = "0" + string;
                    break;
                }
                case 0: {
                    string = "00";
                }
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void writeFile(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] readFile(File file) {
        try {
            byte[] byArray = new byte[(int)file.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dataInputStream.readFully(byArray);
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String readFileAsString(File file) {
        return new String(Model3Helpers.readFile(file));
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new RuntimeException("string " + string + " not an even number of digits");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < byArray.length; ++i) {
            char c = Character.toLowerCase(string.charAt(i * 2));
            char c2 = Character.toLowerCase(string.charAt(i * 2 + 1));
            try {
                int n2 = Model3Helpers.hexcharToInt(c);
                int n3 = Model3Helpers.hexcharToInt(c2);
                byArray[i] = (byte)(n2 * 16 + n3);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("error in hex string \"" + string + "\" " + runtimeException.getMessage());
            }
        }
        return byArray;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int hexcharToInt(char c) {
        if (Character.isDigit(c)) {
            return c - 48;
        }
        if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        throw new RuntimeException(c + " is not a hex digit");
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static List<Thread> getAllThreads() {
        ThreadGroup threadGroup = Model3Helpers.getRootThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2 + 10];
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            arrayList.add(thread);
        }
        return arrayList;
    }

    public static String getFilenameWithoutExtension(String string) {
        return string.substring(0, string.indexOf(46));
    }
}

