/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BytesBuilder {
    private static final int BUFFER_SIZE = 4096;
    private byte[] finalBuffer_;

    public BytesBuilder(InputStream inputStream, DownloadListener downloadListener) {
        try {
            int n;
            int n2 = 0;
            byte[] byArray = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n2 += n;
                if (downloadListener == null) continue;
                downloadListener.progressUpdate(n2);
            }
            this.finalBuffer_ = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] coalesceBuffers(List<byte[]> list, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : list) {
            if (byArray2.length > n - n2) {
                System.arraycopy(byArray2, 0, byArray, n2, n - n2);
                break;
            }
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public int getByteCount() {
        return this.finalBuffer_.length;
    }

    public byte[] asBytes() {
        return this.finalBuffer_;
    }

    public String asString() {
        return new String(this.asBytes());
    }

    public static interface DownloadListener {
        public void progressUpdate(int var1);
    }
}

