/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.model3.launcher.appdef.Resource;
import net.model3.launcher.launcher.LaunchedAppInstallerMonitor;

public class SwingLaunchedAppInstallerMonitor
implements LaunchedAppInstallerMonitor {
    private static final Logger logger = Logger.getLogger(SwingLaunchedAppInstallerMonitor.class.getName());
    private JDialog _dialog;
    private JLabel _statusBar = new JLabel();
    private JProgressBar _progressBar = new JProgressBar();
    private int _totalBytesDownloaded;
    private int _totalBytesToDownload;
    private int _totalFilesToDownload;

    public SwingLaunchedAppInstallerMonitor() {
        this._dialog = new JDialog((Frame)null, "Application Installation Progress Monitor", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this._progressBar, "Center");
        jPanel.add((Component)this._statusBar, "South");
        this._dialog.add(jPanel);
    }

    @Override
    public void show() {
        new Thread(){

            @Override
            public void run() {
                SwingLaunchedAppInstallerMonitor.this._dialog.setLocation(400, 400);
                SwingLaunchedAppInstallerMonitor.this._dialog.setSize(400, 200);
                SwingLaunchedAppInstallerMonitor.this._dialog.setResizable(true);
                SwingLaunchedAppInstallerMonitor.this._dialog.setVisible(true);
            }
        }.start();
    }

    @Override
    public void dispose() {
        new Thread(){

            @Override
            public void run() {
                SwingLaunchedAppInstallerMonitor.this._dialog.setVisible(false);
                SwingLaunchedAppInstallerMonitor.this._dialog.dispose();
            }
        }.start();
    }

    @Override
    public void setTotals(int n, int n2) {
        this._progressBar.setMaximum(n2);
        this._totalFilesToDownload = n;
        this._totalBytesToDownload = n2;
    }

    @Override
    public void progressUpdate(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingLaunchedAppInstallerMonitor.this._progressBar.setValue(SwingLaunchedAppInstallerMonitor.this._totalBytesDownloaded + n);
            }
        });
    }

    @Override
    public void doneDownloading() {
        this._progressBar.setValue(this._totalBytesToDownload);
    }

    @Override
    public void startedDownloading(File file, int n, Resource resource) {
        if (resource != null) {
            this._totalBytesDownloaded = (int)((long)this._totalBytesDownloaded + resource.getSize());
        }
        this._statusBar.setText("downloading file " + n + " of " + this._totalFilesToDownload + "  " + file.getName());
    }

    @Override
    public void setStatusMessage(String string) {
        this._statusBar.setText(string);
    }

    @Override
    public void logProgress() {
        logger.fine(this._progressBar.getValue() + " of " + this._progressBar.getMaximum());
    }
}

