/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.model3.launcher.appdef.ApplicationDefinition;
import net.model3.launcher.appdef.ApplicationManager;
import net.model3.launcher.launcher.LaunchedAppInstallerMonitor;
import net.model3.launcher.launcher.SwingLaunchedAppInstallerMonitor;
import net.model3.launcher.util.LogFormatter;
import net.model3.launcher.util.Model3Helpers;
import net.model3.launcher.util.TimestampedFileHandler;
import net.model3.launcher.util.UrlX;

public class Launcher {
    private static final Logger logger = Logger.getLogger(Launcher.class.getName());
    Properties _properties;
    Process _launchedAppProcess;
    LaunchedAppInstallerMonitor _launchedAppStartupProgressMonitor = new SwingLaunchedAppInstallerMonitor();
    File _applicationDirectory;
    File _libDir;
    File _installDir;
    UrlX _appdefUrl;
    final UrlX _launcherUrl;
    ApplicationDefinition _localAppdef;
    ApplicationDefinition _serverAppdef;
    ApplicationManager _applicationManager;
    File _userDirectory;
    String[] _args;
    UrlX _appInstallBaseUrl;

    public Launcher(UrlX urlX, File file, String[] stringArray) {
        this(urlX, file, stringArray, null);
    }

    public Launcher(UrlX urlX, File file, String[] stringArray, Properties properties) {
        this._appdefUrl = urlX;
        this._args = stringArray;
        this._properties = properties;
        this._launcherUrl = null;
        this.getLaunchedAppStartupProgressMonitor().setStatusMessage("retrieving application descriptor from server");
        this._serverAppdef = new ApplicationDefinition(this._appdefUrl);
        this._libDir = new File(file, "lib");
        this._installDir = new File(this._libDir, this._serverAppdef.getEnvironment());
        this._localAppdef = new ApplicationDefinition(this._serverAppdef.toXml());
        this._installDir.mkdirs();
        Model3Helpers.writeFile(this.getAppdefFile(), this._localAppdef.toXml().getBytes());
        this.init();
    }

    public Launcher(ApplicationDefinition applicationDefinition, File file, Properties properties) {
        this._serverAppdef = applicationDefinition;
        this._appdefUrl = new UrlX(applicationDefinition.getUrl());
        this._args = new String[0];
        this._properties = properties;
        this._launcherUrl = null;
        this._libDir = new File(file, "lib");
        this._installDir = new File(this._libDir, this._serverAppdef.getEnvironment());
        this._localAppdef = new ApplicationDefinition(this._serverAppdef.toXml());
        this._installDir.mkdirs();
        Model3Helpers.writeFile(this.getAppdefFile(), this._localAppdef.toXml().getBytes());
        this.init();
    }

    private void init() {
        this._localAppdef.setAppInstallDir(this._installDir);
        this._localAppdef.setAppInstallBaseUrl(this.getAppInstallBaseUrl());
        this._serverAppdef.setAppInstallDir(this._installDir);
        this._serverAppdef.setAppInstallBaseUrl(this.getAppInstallBaseUrl());
        logger.fine("launcherUrl = " + this._launcherUrl);
    }

    void initProps() {
        File file = new File(this.getUserHome(), this._serverAppdef.getName() + "/user.properties");
        if (file.exists()) {
            try {
                this._properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void start() {
        try {
            this.initializeLogging();
            try {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) {
                            logger.log(Level.WARNING, "uncaught exception", throwable);
                        }
                    }
                });
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "unable to install look and feel", exception);
                }
                logger.info(String.format("launcher init for %s", this.toString()));
                this.installAndLaunchApplication();
                this.startedSuccessfully();
            }
            catch (Throwable throwable) {
                Launcher.showErrorDialog(throwable);
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Launcher.showErrorDialog(throwable);
        }
    }

    public static void showErrorDialog(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JOptionPane.showMessageDialog(null, stringWriter.toString());
        logger.log(Level.SEVERE, "", throwable);
    }

    protected void startedSuccessfully() {
    }

    protected void initializeLogging() {
        this.initializeLoggingHandlers();
        this.initializeLoggingLevels();
    }

    private void initializeLoggingHandlers() {
        logger.info("adding console handler");
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            ((ConsoleHandler)handler).setFormatter(new LogFormatter());
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.log(Level.SEVERE, "uncaught exception", throwable);
            }
        });
        try {
            TimestampedFileHandler timestampedFileHandler = new TimestampedFileHandler(this.getLogsDirectory(), this.getLogsArchiveDirectory(), "launcher-", ".details");
            timestampedFileHandler.setLevel(Level.ALL);
            timestampedFileHandler.setFormatter(new LogFormatter());
            Logger.getLogger("").addHandler(timestampedFileHandler);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "error setting up file handler", exception);
        }
    }

    private void initializeLoggingLevels() {
        if (this.isDeveloperMode()) {
            Logger.getLogger("").setLevel(Level.FINE);
        } else {
            Logger.getLogger("").setLevel(Level.FINE);
        }
        Logger.getLogger("java").setLevel(Level.INFO);
        Logger.getLogger("javax").setLevel(Level.INFO);
        Logger.getLogger("sun").setLevel(Level.INFO);
        logger.info(String.format("developer mode = %s", this.isDeveloperMode()));
    }

    public LaunchedAppInstallerMonitor getLaunchedAppStartupProgressMonitor() {
        return this._launchedAppStartupProgressMonitor;
    }

    void installAndLaunchApplication() {
        this._applicationManager = new ApplicationManager(this);
        this._applicationManager.upToDate();
        this.launchApplication();
    }

    public ApplicationDefinition getServerApplicationDefinition() {
        return this._serverAppdef;
    }

    public void setServerApplicationDefinition(ApplicationDefinition applicationDefinition) {
        this._serverAppdef = applicationDefinition;
    }

    public ApplicationDefinition getLocalApplicationDefinition() {
        return this._localAppdef;
    }

    public void setLocalApplicationDefinition(ApplicationDefinition applicationDefinition) {
        this._localAppdef = applicationDefinition;
    }

    void launchApplication() {
        ApplicationDefinition applicationDefinition = this._applicationManager.getApplication();
        String string = this._properties.getProperty("maxMemory", "");
        if (string.trim().length() > 0) {
            applicationDefinition.setMaxMemory(string);
        }
        applicationDefinition.addSystemProperty("app.description", this.getApplicationDefinition().getDescription());
        applicationDefinition.addSystemProperty("app.name", this.getApplicationDefinition().getName());
        applicationDefinition.addSystemProperty("app.environment", this.getApplicationDefinition().getEnvironment());
        applicationDefinition.addSystemProperty("app.url", this.getApplicationDefinition().getUrl());
        applicationDefinition.addSystemProperty("app.install", this.getInstallationDirectory().getAbsolutePath());
        if (this._launcherUrl != null) {
            applicationDefinition.addSystemProperty("app.launcherUrl", this._launcherUrl.asString());
        }
        for (Object object : System.getProperties().keySet()) {
            String string2 = (String)object;
            if (!string2.startsWith("app.")) continue;
            applicationDefinition.addSystemProperty(string2, System.getProperty(string2));
        }
        this.addPropertiesToApplication(applicationDefinition, this._properties);
        this.doApplicationExecute(applicationDefinition);
        this.getLaunchedAppStartupProgressMonitor().dispose();
    }

    public Process getLaunchedAppProcess() {
        return this._launchedAppProcess;
    }

    public void setLaunchedAppProcess(Process process) {
        this._launchedAppProcess = process;
        StreamMonitor streamMonitor = new StreamMonitor(this._launchedAppProcess.getErrorStream(), Logger.getLogger("app.stderr"), Level.WARNING);
        StreamMonitor streamMonitor2 = new StreamMonitor(this._launchedAppProcess.getInputStream(), Logger.getLogger("app.stdout"), Level.INFO);
        streamMonitor.toString();
        streamMonitor2.toString();
    }

    private void addPropertiesToApplication(ApplicationDefinition applicationDefinition, Properties properties) {
        for (Object object : properties.keySet()) {
            String string = (String)object;
            applicationDefinition.addSystemProperty(string, properties.getProperty(string));
        }
    }

    public File getLogsDirectory() {
        File file = new File(this.getUserHome(), "logs").getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getLogsArchiveDirectory() {
        File file = new File(this.getLogsDirectory(), "archives").getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    File getAppdefFile() {
        return new File(this._libDir, this._serverAppdef.getEnvironment() + ".xml").getAbsoluteFile();
    }

    public void uninstallApplication() {
        for (File file : this.getInstallationDirectory().listFiles()) {
            if (file.delete()) continue;
            logger.warning(String.format("unable to delete %s", file.getAbsolutePath()));
        }
        if (!this.getInstallationDirectory().delete()) {
            logger.warning(String.format("unable to delete %s", this.getInstallationDirectory().getAbsolutePath()));
        }
    }

    public boolean isDeveloperMode() {
        boolean bl = this.getUserPropertyAsBoolean("developer_mode", false);
        if (!bl) {
            bl = this.getDeveloperModeFile().exists();
        }
        return bl;
    }

    public File getUserHome() {
        return new File(System.getProperty("user.home"), this._serverAppdef.getUserHome());
    }

    public File getDeveloperModeFile() {
        return new File(this.getUserHome(), "developer.properties");
    }

    public boolean getUserPropertyAsBoolean(String string, boolean bl) {
        String string2 = this._properties.getProperty(string, String.valueOf(bl)).trim();
        return string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on");
    }

    protected void doApplicationExecute(ApplicationDefinition applicationDefinition) {
        if (applicationDefinition.executeInSeperateProcess()) {
            logger.info("starting standalone application");
            this.setLaunchedAppProcess(applicationDefinition.execute(this._args));
            logger.info("standalone application started");
        } else {
            logger.info("starting in process application");
            applicationDefinition.executeInProcess(this._args);
            logger.info("in process application started");
        }
    }

    public UrlX getAppdefUrl() {
        return this._appdefUrl;
    }

    public ApplicationDefinition getApplicationDefinition() {
        return this._localAppdef;
    }

    public File getInstallationDirectory() {
        return this._installDir;
    }

    public UrlX getAppInstallBaseUrl() {
        if (this._appInstallBaseUrl == null) {
            this._appInstallBaseUrl = new UrlX(this.getAppdefUrl().getParentUrl(), "appinstall");
        }
        return this._appInstallBaseUrl;
    }

    class StreamMonitor
    extends Thread {
        BufferedReader _reader;
        Logger _logger;
        Level _level;

        public StreamMonitor(InputStream inputStream, Logger logger, Level level) {
            this._reader = new BufferedReader(new InputStreamReader(inputStream));
            this._logger = logger;
            this._level = level;
            this.start();
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this._reader.readLine()) != null) {
                    this._logger.log(this._level, string);
                }
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "", exception);
            }
        }
    }
}

