/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.appdef;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.File;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.model3.launcher.appdef.ApplicationDefinition;
import net.model3.launcher.util.BytesBuilder;
import net.model3.launcher.util.Model3Helpers;
import net.model3.launcher.util.UrlX;

public class Resource {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    transient ApplicationDefinition _application;
    @XStreamAlias(value="size")
    long _size;
    @XStreamAlias(value="md5")
    byte[] _md5;
    transient byte[] _calculatedMd5;
    @XStreamAlias(value="name")
    String _name;

    public Resource() {
    }

    public Resource(ApplicationDefinition applicationDefinition) {
        this._application = applicationDefinition;
    }

    public void setApplication(ApplicationDefinition applicationDefinition) {
        this._application = applicationDefinition;
    }

    public void download(BytesBuilder.DownloadListener downloadListener) {
        this._calculatedMd5 = null;
        File file = this.getFile();
        UrlX urlX = new UrlX(this._application.getAppInstallBaseUrl(), this.getName());
        Exception exception = null;
        boolean bl = false;
        logger.info(String.format("downloading %s", urlX.toString()));
        int n = 3;
        for (int i = 0; i <= n; ++i) {
            try {
                byte[] byArray = urlX.downloadAsBytesBuilder(downloadListener).asBytes();
                Model3Helpers.writeFile(file, byArray);
                if (!this.hasMatchingFileSizesAndChecksums()) continue;
                bl = true;
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
                logger.log(Level.WARNING, "error downloading " + urlX + " on retry " + n + " will retry " + (n - i) + " more times", exception2);
            }
        }
        if (!bl) {
            logger.info(String.format("downloading of %s failed", urlX.toString()));
            exception.printStackTrace();
            throw new RuntimeException("failed to download " + urlX, exception);
        }
        logger.info(String.format("downloading of %s completed successfully", urlX.toString()));
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long l) {
        this._size = l;
    }

    public String getMd5AsString() {
        return Model3Helpers.byteArrayToHexString(this.getMd5());
    }

    public void setMd5(String string) {
        this._md5 = Model3Helpers.hexStringToByteArray(string);
    }

    public byte[] getMd5() {
        return this._md5;
    }

    public void setMd5(byte[] byArray) {
        this._md5 = byArray;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public File getFile() {
        return new File(this._application.getAppInstallDir(), this.getName()).getAbsoluteFile();
    }

    public boolean hasMatchingFileSizesAndChecksums() {
        if (!this.getFile().exists()) {
            return false;
        }
        if (!this.declaredAndActualFileSizesMatch()) {
            return false;
        }
        return this.declaredAndActualCheckSumsMatch();
    }

    boolean declaredAndActualFileSizesMatch() {
        long l;
        long l2 = this.getSize();
        if (l2 != (l = this.getFile().length())) {
            logger.warning("file size mismatch on " + this.getFile().getName() + "  expected = " + l2 + "  actual = " + l);
            return false;
        }
        return true;
    }

    boolean declaredAndActualCheckSumsMatch() {
        byte[] byArray;
        boolean bl;
        if (this._calculatedMd5 == null) {
            this.calculateMd5();
        }
        if (!(bl = Model3Helpers.equals(byArray = this.getMd5(), this._calculatedMd5))) {
            logger.warning("md5 mismatch on " + this.getFile().getName() + "  expected = " + Model3Helpers.byteArrayToHexString(byArray) + "  actual = " + Model3Helpers.byteArrayToHexString(this._calculatedMd5));
            return false;
        }
        return true;
    }

    public byte[] calculateMd5() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = Model3Helpers.readFile(this.getFile());
            byte[] byArray2 = messageDigest.digest(byArray);
            this._calculatedMd5 = byArray2;
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this._name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._name == null ? 0 : this._name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Resource resource = (Resource)object;
        return !(this._name == null ? resource._name != null : !this._name.equals(resource._name));
    }
}

