/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.appdef;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.model3.launcher.appdef.ApplicationDefinition;
import net.model3.launcher.appdef.DownloadBundle;
import net.model3.launcher.appdef.Resource;
import net.model3.launcher.launcher.Launcher;

public class ApplicationManager {
    private static final Logger logger = Logger.getLogger(ApplicationManager.class.getName());
    Launcher _launcher;

    public ApplicationManager(Launcher launcher) {
        this._launcher = launcher;
        launcher.getLaunchedAppStartupProgressMonitor().show();
    }

    public void upToDate() {
        logger.info("attempting to update the app");
        this._launcher.getLaunchedAppStartupProgressMonitor().setStatusMessage(this._launcher.getApplicationDefinition().getDescription() + " is checking for and installing updates");
        this.downloadLatest();
        this._launcher.getLaunchedAppStartupProgressMonitor().doneDownloading();
        this.removeDanglingFiles();
        try {
            this._launcher.getApplicationDefinition().validateInstallation();
        }
        catch (Exception exception) {
            JOptionPane.showConfirmDialog(null, "Installation failed because \n" + exception.getMessage());
            throw new RuntimeException("installation failed");
        }
    }

    private void downloadLatest() {
        DownloadBundle downloadBundle = this._launcher.getApplicationDefinition().getResourcesToDownload();
        this._launcher.getLaunchedAppStartupProgressMonitor().setTotals(downloadBundle._resources.size(), downloadBundle._totalByteCount);
        int n = 1;
        Resource resource = null;
        for (Resource resource2 : downloadBundle._resources) {
            this._launcher.getLaunchedAppStartupProgressMonitor().startedDownloading(resource2.getFile(), n, resource);
            resource2.download(this._launcher.getLaunchedAppStartupProgressMonitor());
            ++n;
            resource = resource2;
        }
    }

    private void removeDanglingFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String object : this.getLocalApplicationFilenames()) {
            hashSet.add(object.toLowerCase());
        }
        logger.info("checking to see if an update is needed");
        for (Resource resource : this._launcher.getApplicationDefinition().getResources()) {
            hashSet.remove(resource.getName().toLowerCase());
        }
        for (String string : hashSet) {
            File file = new File(this._launcher.getInstallationDirectory(), string);
            file.delete();
            if (!file.exists()) continue;
            logger.warning("unable to remove file " + string);
        }
    }

    Set<String> getLocalApplicationFilenames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : this._launcher.getInstallationDirectory().listFiles()) {
            hashSet.add(file.getName());
        }
        return hashSet;
    }

    public ApplicationDefinition getApplication() {
        return this._launcher.getApplicationDefinition();
    }

    public Launcher getLauncher() {
        return this._launcher;
    }
}

