/*
 * Decompiled with CFR 0.152.
 */
package net.model3.launcher.appdef;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.model3.launcher.appdef.DownloadBundle;
import net.model3.launcher.appdef.Resource;
import net.model3.launcher.testapp.HelloWorld;
import net.model3.launcher.util.Model3Helpers;
import net.model3.launcher.util.UrlX;

@XStreamAlias(value="app")
public class ApplicationDefinition {
    public static final String NAME_APPDEF_JSP = "appdef.jsp";
    public static final String NAME_APPDEF_SOURCE = "appdef-source.xml";
    public static final String NAME_APPDEF_GENERATED = "appdef-generated.xml";
    public static final String NAME_APPINSTALL_FOLDER = "appinstall";
    private static final Logger logger = Logger.getLogger(ApplicationDefinition.class.getName());
    @XStreamImplicit(itemFieldName="resource")
    List<Resource> _resources = new ArrayList<Resource>();
    @XStreamAlias(value="userHome")
    String _userHome = "";
    @XStreamAlias(value="name")
    String _name = "";
    @XStreamAlias(value="environment")
    String _environment = "";
    @XStreamAlias(value="description")
    String _description = "";
    @XStreamAlias(value="url")
    String _url = "";
    @XStreamAlias(value="uuid")
    UUID _uuid;
    @XStreamAlias(value="seperateProcess")
    boolean _seperateProcess = true;
    @XStreamAlias(value="jvmParms")
    Map<String, String> _jvmParms = new HashMap<String, String>();
    @XStreamAlias(value="systemProperties")
    Map<String, String> _systemProperties = new HashMap<String, String>();
    @XStreamAlias(value="created")
    String _generated = new Date().toString();
    @XStreamAlias(value="mainClass")
    String _mainClass = HelloWorld.class.getName();
    @XStreamAlias(value="exeLauncher")
    String _exeLauncher = null;
    transient String _sourceXml;
    transient File _appInstallDir;
    transient File _sourceFile;
    private UrlX _appInstallBaseUrl;

    public ApplicationDefinition() {
    }

    public ApplicationDefinition(UrlX urlX) {
        this.loadFromXml(urlX.getContentAsString());
        this._url = urlX.toString();
    }

    public ApplicationDefinition(File file) {
        this();
        this._sourceFile = file;
        this.loadFromXml(file);
    }

    public ApplicationDefinition(String string) {
        this();
        this.loadFromXml(string);
    }

    public void setResources(List<Resource> list) {
        this._resources = list;
        for (Resource resource : this._resources) {
            resource.setApplication(this);
        }
    }

    public String toXml() {
        return ApplicationDefinition.createXStreamer().toXML((Object)this);
    }

    String getClasspath() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Resource resource : this._resources) {
            if (!resource.getName().endsWith(".jar")) continue;
            stringBuilder.append(string);
            stringBuilder.append(resource.getName());
            string = System.getProperty("path.separator");
        }
        return stringBuilder.toString();
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public DownloadBundle getResourcesToDownload() {
        DownloadBundle downloadBundle = new DownloadBundle();
        for (Resource resource : this.getResources()) {
            if (resource.hasMatchingFileSizesAndChecksums()) continue;
            downloadBundle.add(resource);
        }
        return downloadBundle;
    }

    URL[] getURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Resource resource : this._resources) {
            if (!resource.getName().endsWith(".jar")) continue;
            try {
                arrayList.add(resource.getFile().toURI().toURL());
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "error making url for resource " + resource.getName(), exception);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    public void executeInProcess(final String[] stringArray) {
        try {
            for (Map.Entry<String, String> object2 : this._systemProperties.entrySet()) {
                System.setProperty(object2.getKey(), object2.getValue());
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(this.getURLs(), Thread.currentThread().getContextClassLoader());
            Class<?> clazz = uRLClassLoader.loadClass(this._mainClass);
            final Method method = clazz.getMethod("main", String[].class);
            method.setAccessible(true);
            ThreadGroup threadGroup = new ThreadGroup("main-spawened");
            Thread thread = new Thread(threadGroup, "main-spawned"){

                @Override
                public void run() {
                    try {
                        method.invoke(null, new Object[]{stringArray});
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "error while running " + ApplicationDefinition.this._mainClass, exception);
                    }
                }
            };
            this.doLauncherCloassLoaderFix(uRLClassLoader);
            thread.setDaemon(false);
            thread.setContextClassLoader(uRLClassLoader);
            thread.start();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "error while starting " + this._mainClass, exception);
            throw new RuntimeException(exception);
        }
    }

    private void doLauncherCloassLoaderFix(final ClassLoader classLoader) {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader == classLoader2) {
            return;
        }
        for (Thread thread : Model3Helpers.getAllThreads()) {
            if (thread.getContextClassLoader() != classLoader2) continue;
            thread.setContextClassLoader(classLoader);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                logger.info(String.format("AWT-EventQueue classloader switched to %s", classLoader.toString()));
                Thread.currentThread().setContextClassLoader(classLoader);
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                classLoader2.toString();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                logger.info(String.format("AWT-EventQueue using classloader %s", Thread.currentThread().getContextClassLoader().toString()));
            }
        });
    }

    String getExeExtension() {
        if (Model3Helpers.isWindows()) {
            return ".exe";
        }
        return "";
    }

    public Process execute(String[] stringArray) {
        try {
            String string10;
            File file = this.getAppInstallDir();
            String string2 = System.getProperty("java.home");
            String string3 = string2 + File.separator + "bin";
            String string4 = this.getExeExtension();
            String string5 = string3 + File.separator + "javaw" + string4;
            File file2 = new File(string5);
            if (!file2.exists()) {
                string5 = string3 + File.separator + "java" + string4;
                file2 = new File(string5);
            }
            if (Model3Helpers.isWindows() && this._exeLauncher != null) {
                string5 = file.getCanonicalFile() + File.separator + this._exeLauncher;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string5);
            for (String object22 : this._jvmParms.keySet()) {
                String string6 = this._jvmParms.get(object22);
                string10 = object22 + string6;
                logger.info(String.format("adding command line argument '%s'", string10));
                arrayList.add(string10);
            }
            for (String string7 : this._systemProperties.keySet()) {
                String string8 = this._systemProperties.get(string7);
                string10 = "-D" + string7 + "=" + string8;
                logger.info(String.format("adding command line argument '%s'", string10));
                arrayList.add(string10);
            }
            arrayList.add("-cp");
            arrayList.add(this.getClasspath());
            arrayList.add(this._mainClass);
            arrayList.addAll(Arrays.asList(stringArray));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            for (String string9 : System.getenv().keySet()) {
                string10 = System.getenv(string9);
                if (string9.equalsIgnoreCase("PATH")) {
                    string10 = file.getCanonicalPath() + File.pathSeparator + string3 + File.pathSeparator + string10;
                }
                processBuilder.environment().put(string9, string10);
            }
            processBuilder.directory(file.getCanonicalFile());
            processBuilder.redirectErrorStream(true);
            processBuilder.command(arrayList);
            logger.info("command line parms");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string10 : arrayList) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append('\"');
                stringBuilder.append(string10);
                stringBuilder.append('\"');
            }
            logger.info(String.format("command line = \n%s", stringBuilder));
            Process process = processBuilder.start();
            logger.info(String.format("application started with process=%s", process.toString()));
            return process;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    String createCustomExe(String string, String string2, String string3, File file) {
        String string4 = string + File.separator + "bin" + File.separator + this.getName() + "-" + this.getEnvironment() + "-java" + string2;
        File file2 = new File(string4);
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            byte[] byArray = new byte[8192];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "unable to copy {0} to {1}", new Object[]{string3, string4});
        }
        if (file2.exists() && file2.length() == file.length()) {
            logger.log(Level.FINE, "using customer launcher {0}", string4);
            string3 = string4;
            file = file2;
        }
        return string3;
    }

    public String getGenerated() {
        return this._generated;
    }

    public void setGenerated(String string) {
        this._generated = string;
        this.addSystemProperty("app.xml.created", this._generated);
    }

    public String getMainClass() {
        return this._mainClass;
    }

    public void setMainClass(String string) {
        this._mainClass = string;
    }

    public final void loadFromXml(String string) {
        XStream xStream = ApplicationDefinition.createXStreamer();
        xStream.fromXML(string, (Object)this);
        for (Resource resource : this.getResources()) {
            resource.setApplication(this);
        }
        this._sourceXml = string;
    }

    public final void loadFromXml(File file) {
        try {
            this.loadFromXml(Model3Helpers.readFileAsString(file));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static XStream createXStreamer() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.processAnnotations(ApplicationDefinition.class);
        xStream.processAnnotations(Resource.class);
        return xStream;
    }

    public String getMaxMemory() {
        return this._jvmParms.get("-Xmx");
    }

    public void setMaxMemory(String string) {
        this._jvmParms.put("-Xmx", string);
    }

    public void validateInstallation() {
        for (Resource resource : this.getResources()) {
            if (resource.hasMatchingFileSizesAndChecksums()) continue;
            throw new RuntimeException("resource " + resource.getName() + " does not pass validation.");
        }
    }

    public String getEnvironment() {
        return this._environment;
    }

    public String getSourceXml() {
        return this._sourceXml;
    }

    public void addSystemProperty(String string, String string2) {
        this._systemProperties.put(string, string2);
    }

    public boolean executeInSeperateProcess() {
        return this._seperateProcess;
    }

    public String getUrl() {
        return this._url;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public File getAppInstallDir() {
        return this._appInstallDir;
    }

    public void setAppInstallDir(File file) {
        this._appInstallDir = file;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID uUID) {
        this._uuid = uUID;
    }

    public String getUserHome() {
        return this._userHome;
    }

    public void loadApplicationResources(File file) {
        if (file != null && file.exists()) {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            for (File file2 : file.listFiles()) {
                Resource resource = new Resource(this);
                resource.setName(file2.getName());
                arrayList.add(resource);
                resource.setSize(file2.length());
                resource.setMd5(resource.calculateMd5());
            }
            this._resources = arrayList;
        }
    }

    public UrlX getAppInstallBaseUrl() {
        return this._appInstallBaseUrl;
    }

    public void setAppInstallBaseUrl(UrlX urlX) {
        this._appInstallBaseUrl = urlX;
    }
}

