/*
 * Decompiled with CFR 0.152.
 */
package net.model3.json;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.json.DataModelProvider;
import net.model3.json.GridConfig;
import net.model3.json.JSONException;
import net.model3.json.JSONObject;
import net.model3.json.JSONString;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.RegexX;

public class JSONWriter {
    private static final int maxdepth = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private char[] stack = new char[20];
    private int top = 0;
    private int indentationLevel = 0;
    private boolean indent = true;
    private String spacesPerIndent = "  ";
    protected Writer writer;
    private DataModelProvider _dataModelProvider;
    private boolean _alwaysQuoteKeys = false;
    public static Pattern _JS_QUOTE_CHARS = Pattern.compile("\\W");

    public JSONWriter(Writer writer) {
        this.writer = writer;
    }

    public JSONWriter(Writer writer, boolean bl) {
        this(writer);
        this._alwaysQuoteKeys = bl;
    }

    public DataModelProvider getDataModelProvider() {
        return this._dataModelProvider;
    }

    public void setDataModelProvider(DataModelProvider dataModelProvider) {
        this._dataModelProvider = dataModelProvider;
    }

    private JSONWriter append(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(string);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            this.indent();
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONWriter end(char c, char c2) throws JSONException {
        if (this.mode != c) {
            throw new JSONException(c == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(c);
        try {
            this.writer.write(c2);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        this.unindent();
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        this.unindent();
        return this.end('k', '}');
    }

    public JSONWriter key(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.writer.write(44);
                }
                if (RegexX.test((String)string, (Pattern)_JS_QUOTE_CHARS) || this._alwaysQuoteKeys) {
                    this.writer.write(JSONObject.quote(string));
                } else {
                    this.writer.write(string);
                }
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            this.indent();
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) throws JSONException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws JSONException {
        if (this.top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public JSONWriter value(boolean bl) throws JSONException {
        return this.append(bl ? "true" : "false");
    }

    public JSONWriter value(double d) throws JSONException {
        return this.value(new Double(d));
    }

    public JSONWriter value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    void indent() throws JSONException {
        ++this.indentationLevel;
        this.doIndenting();
    }

    void unindent() throws JSONException {
        --this.indentationLevel;
        this.doIndenting();
    }

    void doIndenting() throws JSONException {
        if (this.indent) {
            try {
                this.writer.write("\n");
                for (int i = 0; i < this.indentationLevel; ++i) {
                    this.writer.write(this.spacesPerIndent);
                }
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }
    }

    public void property(RProperty<?> rProperty) {
        this.key(rProperty.getContext().getName());
        if (rProperty.getContext().isIndexedProperty()) {
            this.array();
            for (Object e : (IndexedProperty)rProperty) {
                this.value(e);
            }
            this.endArray();
        } else {
            this.value(rProperty.get());
        }
    }

    public JSONWriter value(Object object) throws JSONException {
        return this.append(JSONObject.valueToString(object));
    }

    public void outputGrid(final GridConfig gridConfig) {
        try {
            gridConfig._dataModel = this.getDataModelProvider();
            this.value(new JSONString(){

                @Override
                public String toJSONString() {
                    return gridConfig.createGrid().write();
                }
            });
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void outputGrid(List<?> list, RProperty<?> ... rPropertyArray) {
        GridConfig gridConfig = new GridConfig();
        gridConfig.rows = list;
        gridConfig.addColumns((PropertyContextable[])rPropertyArray);
        this.outputGrid(gridConfig);
    }

    public void outputDropDown(List<?> list, PropertyContextable propertyContextable, PropertyContextable propertyContextable2) {
        try {
            JSONWriter jSONWriter = this;
            jSONWriter.array();
            for (Object obj : list) {
                if (obj == null) {
                    jSONWriter.object();
                    jSONWriter.key("d");
                    jSONWriter.value("");
                    jSONWriter.key("u");
                    jSONWriter.value(null);
                    jSONWriter.endObject();
                    continue;
                }
                jSONWriter.object();
                jSONWriter.key("d");
                jSONWriter.value(propertyContextable2.getContext().getValue(obj));
                jSONWriter.key("u");
                Object object = propertyContextable.getContext().getValue(obj);
                jSONWriter.value(object.toString());
                jSONWriter.endObject();
            }
            jSONWriter.endArray();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }
}

