/*
 * Decompiled with CFR 0.152.
 */
package net.model3.json;

import com.google.inject.Inject;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.model3.chrono.DateTime;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.javascript.jsx.Grid;
import net.model3.json.DataModelProvider;
import net.model3.json.IdPropertyContext;
import net.model3.json.JSONObject;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;

public class GridConfig {
    public boolean newUsesPropertyPage = true;
    public List<Column> columns = ListX.create();
    public List<?> rows;
    public String rowProcessor;
    public boolean allowDeletes = false;
    public JSONObject breadcrumbsParm;
    public PropertyContextable idProperty;
    public DataModelProvider _dataModel;
    @Inject
    SessionConfiguration _sessionConfiguration;

    public GridConfig() {
        DependencyInjector.inject((Object)this);
    }

    public void addColumns(PropertyContextable ... propertyContextableArray) {
        for (PropertyContextable propertyContextable : propertyContextableArray) {
            Column column = new Column();
            column._heading = propertyContextable.getContext().getName();
            column._context = propertyContextable.getContext();
            this.columns.add(column);
        }
    }

    public void addColumn(String string, PropertyContextable propertyContextable) {
        Column column = new Column();
        column._uid = propertyContextable.getContext().getName();
        column._heading = string;
        column._context = propertyContextable.getContext();
        this.columns.add(column);
    }

    public DataModelProvider getDataModelProvider() {
        return this._dataModel;
    }

    public Grid createGrid() {
        Object object;
        int n;
        if (this.idProperty == null) {
            this.idProperty = new IdPropertyContext(":uid");
        }
        Grid grid = new Grid();
        grid.setDynamicRows(this.newUsesPropertyPage);
        grid.addBreadcrumbs(this.breadcrumbsParm);
        if (this.rowProcessor != null) {
            grid.addRowProcessor(this.rowProcessor);
        }
        for (n = 0; n < this.columns.size(); ++n) {
            Column column = this.columns.get(n);
            object = column._context;
            if (object.isIndexedProperty() && this._sessionConfiguration.getPersister(object.getType()) != null) {
                grid.addConfig(n, "jump");
            }
            grid.addHeader(column._heading, column._uid);
            if (StringX.isNotBlank((String)column._uid)) {
                grid.addHeaderFormatSuppression(n);
            }
            boolean bl = false;
            if (Date.class.isAssignableFrom(object.getType()) || DateTime.class.isAssignableFrom(object.getType())) {
                bl = true;
                grid.addFormat(n, "date");
            } else if (Time.class.isAssignableFrom(object.getType())) {
                bl = true;
                grid.addFormat(n, "time");
            }
            if (object.getType().equals(String.class)) {
                grid.addStyle(n, "oLeft");
                continue;
            }
            if (ClassX.isAssignable(Number.class, (Class)object.getType())) {
                grid.addStyle(n, "oRight");
                continue;
            }
            if (bl) {
                grid.addStyle(n, "oLeft");
                continue;
            }
            grid.addStyle(n, "oLeft");
        }
        if (this.allowDeletes) {
            n = grid.addHeader("Delete");
            grid.addStyle(n, "oCenter");
            grid.addConfig(n, "buttonDeleteRow");
            grid.addSortSupression(n);
            grid.addNonDataFlag(n);
        }
        for (Column column : this.rows) {
            object = grid.addBodyRow(this.idProperty.getContext().getValue((Object)column));
            for (Column column2 : this.columns) {
                IPropertyContext iPropertyContext = column2._context;
                Object object2 = iPropertyContext.getValue((Object)column);
                if (object2 != null && this._sessionConfiguration.getPersister(iPropertyContext.getType(), false) != null) {
                    String string;
                    String string2;
                    Object[] objectArray;
                    IPropertyContext iPropertyContext2;
                    if (object2 instanceof Collection) {
                        iPropertyContext2 = this.getDataModelProvider().getVisualId(iPropertyContext.getType());
                        objectArray = ListX.create();
                        List list = ListX.create();
                        for (Object e : (Collection)object2) {
                            Object[] objectArray2 = CurrentSession.get().getPrimaryKey(e);
                            objectArray.add(StringX.join((Object[])objectArray2, (String)":"));
                            list.add((String)iPropertyContext2.getValue(e));
                        }
                        string2 = StringX.join((Iterable)list, (String)", ", null);
                        string = StringX.join((Iterable)objectArray, (String)",", null);
                    } else {
                        iPropertyContext2 = this.getDataModelProvider().getVisualId(iPropertyContext.getType());
                        objectArray = CurrentSession.get().getPrimaryKey(object2);
                        string = StringX.join((Object[])objectArray, (String)":");
                        string2 = (String)iPropertyContext2.getValue(object2);
                    }
                    ((Grid.BodyRow)object).addCell((Object)string2, string, null);
                    continue;
                }
                ((Grid.BodyRow)object).addCell(object2);
            }
            if (!this.allowDeletes) continue;
            ((Grid.BodyRow)object).addCell("");
        }
        return grid;
    }

    public static class Column {
        private String _uid;
        private String _heading;
        private IPropertyContext _context;
    }
}

