/*
 * Decompiled with CFR 0.152.
 */
package net.model3.javascript.jsx;

import java.io.PrintWriter;
import java.math.BigDecimal;
import net.model3.javascript.JS;
import net.model3.javascript.JsArray;
import net.model3.javascript.JsonObject;
import net.model3.lang.StringX;

public class Grid
extends JS {
    private JsonObject _data = new JsonObject();
    private JsArray _header = new JsArray();
    private JsonObject _grid = new JsonObject();
    private JsonObject _gridParms = new JsonObject();
    private JsonObject _rows = new JsonObject();
    private JsonObject _cols = new JsonObject();
    private JsonObject _styles = new JsonObject();
    private JsonObject _editors = new JsonObject();
    private JsonObject _configs = new JsonObject();
    private JsonObject _types = new JsonObject();
    private JsonObject _sorts = new JsonObject();
    private JsonObject _formats = new JsonObject();
    private JsonObject _headerFormats = new JsonObject();
    private JsArray _footer = new JsArray();
    private JsonObject _colData = new JsonObject();
    public static final String UID = "u";
    public static final String DISPLAY = "d";
    public static final String ATTRIBUTES = "a";
    public static final String STYLE = "y";
    public static final String SORT = "r";
    public static final String EDITOR = "e";
    public static final String TYPE = "t";
    public static final String CONFIG = "c";
    public static final String ROW_PROCESSORS = "rp";
    public static final String GRID_PARMS = "parms";
    public static final String BREADCRUMBS = "breadcrumbs";
    public static final String DATA = "dt";
    public static final String FORMATTER = "f";
    public static final String HEADER_FORMAT = "hf";
    private JsonObject _oBody = new JsonObject();
    public static final String RIGHT_ALIGN_STYLE = "oRight";
    public static final String CENTER_ALIGN_STYLE = "oCenter";
    public static final String LEFT_ALIGN_STYLE = "oLeft";
    public static final String BOLD_TEXT = "oBold";
    public static final String BUTTON_LEFT = "buttonLeft";
    public static final String BUTTON_CENTER = "buttonCenter";
    public static final String BUTTON_CENTER_MAX_HEIGHT = "buttonCenterMaxHeight";
    public static final String BUTTON_RIGHT = "buttonRight";
    public static final String BUTTON_DELETE = "buttonDeleteRow";
    public static final String DYNAMIC_ROWS = "dynamicRows";
    public static final String DATE_FORMAT = "date";
    public static final String TIME_FORMAT = "time";
    public static final String MONEY_FORMAT = "money";
    public static final String PERCENT_FORMAT = "percent";

    public Grid() {
        this._data.set("grid", (Object)this._grid);
        this._grid.set(GRID_PARMS, (Object)this._gridParms);
        this._data.set("thead", (Object)this._header);
        this._data.set("tbody", (Object)this._oBody);
        this._data.set("tfoot", (Object)this._footer);
        this._data.set("rows", (Object)this._rows);
        this._data.set("cols", (Object)this._cols);
        this._cols.set(STYLE, (Object)this._styles);
        this._cols.set(EDITOR, (Object)this._editors);
        this._cols.set(CONFIG, (Object)this._configs);
        this._cols.set(SORT, (Object)this._sorts);
        this._cols.set(DATA, (Object)this._colData);
        this._cols.set(TYPE, (Object)this._types);
        this._cols.set(FORMATTER, (Object)this._formats);
        this._cols.set(HEADER_FORMAT, (Object)this._headerFormats);
    }

    @Override
    public void write(PrintWriter printWriter) throws Exception {
        this._data.write(printWriter);
    }

    private void addProperty(JsonObject jsonObject, int n, Object object) {
        jsonObject.set(String.valueOf(n), object);
    }

    private void addProperty(JsonObject jsonObject, int[] nArray, Object object) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addProperty(jsonObject, nArray[i], object);
        }
    }

    public void addBreadcrumbs(Object object) {
        this._gridParms.set(BREADCRUMBS, object);
    }

    public void addParm(String string, Object object) {
        this._gridParms.set(string, object);
    }

    public void setDynamicRows(boolean bl) {
        this._grid.set(DYNAMIC_ROWS, (Object)bl);
    }

    public void addEditor(int[] nArray, String string) {
        this.addProperty(this._editors, nArray, (Object)string);
    }

    public void addEditor(int n, String string) {
        this.addProperty(this._editors, n, (Object)string);
    }

    public void addEditorSuppression(int[] nArray) {
        this.addProperty(this._editors, nArray, (Object)false);
    }

    public void addEditorSuppression(int n) {
        this.addProperty(this._editors, n, (Object)false);
    }

    public void addNonDataFlag(int n) {
        this.addProperty(this._colData, n, (Object)false);
    }

    public void addNonDataFlag(int[] nArray) {
        this.addProperty(this._colData, nArray, (Object)false);
    }

    public void addConfig(int n, String string) {
        this.addProperty(this._configs, n, (Object)string);
    }

    public void addConfig(int[] nArray, String string) {
        this.addProperty(this._configs, nArray, (Object)string);
    }

    public void addSortSupression(int[] nArray) {
        this.addProperty(this._sorts, nArray, (Object)false);
    }

    public void addSortSupression(int n) {
        this.addProperty(this._sorts, n, (Object)false);
    }

    public void addFormat(int[] nArray, String string) {
        this.addProperty(this._formats, nArray, (Object)string);
    }

    public void addFormat(int n, String string) {
        this.addProperty(this._formats, n, (Object)string);
    }

    public void addStyle(int[] nArray, String string) {
        this.addProperty(this._styles, nArray, (Object)string);
    }

    public void addStyle(int n, String string) {
        this.addProperty(this._styles, n, (Object)string);
    }

    public void addRowProcessor(String string) {
        this._rows.set(ROW_PROCESSORS, (Object)string);
    }

    public void addHeaderFormatSuppression(int[] nArray) {
        this.addProperty(this._headerFormats, nArray, (Object)false);
    }

    public void addHeaderFormatSuppression(int n) {
        this.addProperty(this._headerFormats, n, (Object)false);
    }

    private int addHeader(String string, String string2, JsonObject jsonObject, String string3) {
        int n = this._header.length();
        if (jsonObject != null || string3 != null || string2 != null) {
            JsonObject jsonObject2 = new JsonObject(DISPLAY, string);
            if (string2 != null) {
                jsonObject2.set(UID, (Object)string2);
            }
            if (jsonObject != null) {
                jsonObject2.set(ATTRIBUTES, (Object)jsonObject);
            }
            if (string3 != null) {
                jsonObject2.set(CONFIG, (Object)string3);
            }
            this._header.push(jsonObject2);
        } else {
            this._header.push(string);
        }
        return n;
    }

    public int[] addHeader(String[] stringArray, String[] stringArray2, JsonObject jsonObject, String string) {
        int[] nArray = new int[stringArray.length];
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.addHeader(stringArray[i], stringArray2[i], jsonObject, string);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.addHeader(stringArray[i], null, jsonObject, string);
            }
        }
        return nArray;
    }

    public int[] addHeader(String[] stringArray) {
        return this.addHeader(stringArray, null, null, null);
    }

    public int addHeader(String string) {
        return this.addHeader(string, null, null, null);
    }

    public int[] addHeader(String[] stringArray, String[] stringArray2) {
        return this.addHeader(stringArray, stringArray2, null, null);
    }

    public int addHeader(String string, String string2) {
        return this.addHeader(string, string2, null, null);
    }

    public int[] addHeader(String[] stringArray, String[] stringArray2, JsonObject jsonObject) {
        return this.addHeader(stringArray, stringArray2, jsonObject, null);
    }

    public int addHeader(String string, String string2, JsonObject jsonObject) {
        return this.addHeader(string, string2, jsonObject, null);
    }

    public int addHeaderLeftAlign(String string) {
        int n = this.addHeader(string);
        this.addStyle(n, LEFT_ALIGN_STYLE);
        return n;
    }

    public int[] addHeaderLeftAlign(String[] stringArray) {
        int[] nArray = this.addHeader(stringArray);
        this.addStyle(nArray, LEFT_ALIGN_STYLE);
        return nArray;
    }

    public int addHeaderRightAlign(String string) {
        int n = this.addHeader(string);
        this.addStyle(n, RIGHT_ALIGN_STYLE);
        return n;
    }

    public int[] addHeaderRightAlign(String[] stringArray) {
        int[] nArray = this.addHeader(stringArray);
        this.addStyle(nArray, RIGHT_ALIGN_STYLE);
        return nArray;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public FormattedBodyRow addFormattedBodyRow() {
        int n = this._oBody.size();
        return this.addFormattedBodyRow(n);
    }

    public FormattedBodyRow addFormattedBodyRow(Object object) {
        FormattedBodyRow formattedBodyRow = new FormattedBodyRow();
        this._oBody.set(String.valueOf(object), (Object)formattedBodyRow);
        return formattedBodyRow;
    }

    public BodyRow addBodyRow() {
        int n = this._oBody.size();
        return this.addBodyRow(n);
    }

    public BodyRow addBodyRow(Object object) {
        FormattedBodyRow formattedBodyRow = new FormattedBodyRow();
        this._oBody.set(String.valueOf(object), (Object)formattedBodyRow);
        return formattedBodyRow;
    }

    public BodyRow addFooterRow() {
        BodyRow bodyRow = new BodyRow();
        this._footer.push(bodyRow);
        return bodyRow;
    }

    public class FormattedBodyRow
    extends BodyRow {
        public void addCell(Object object, Object object2, String[] stringArray) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.SORT, Grid.STYLE}, new Object[]{object, object2, new JsArray(stringArray)}));
        }

        public void addCell(Object object, Object object2, String string) {
            this.addCell(object, object2, new String[]{string});
        }

        public void addCell(Object object, Object object2) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.SORT}, new Object[]{object, object2}));
        }

        @Override
        public void addCell(int n) {
            this.addCell((Object)StringX.formatCommas((String)String.valueOf(n)), (Object)n);
        }

        @Override
        public void addCell(float f) {
            this.addCell((Object)StringX.formatCommas((float)f), Float.valueOf(f));
        }

        @Override
        public void addCell(BigDecimal bigDecimal, int n) {
            this.addCell(bigDecimal.setScale(n, 4).floatValue());
        }

        @Override
        public void addCell(BigDecimal bigDecimal, int n, String[] stringArray) {
            this.addCell((Object)Float.valueOf(bigDecimal.setScale(n, 4).floatValue()), stringArray);
        }

        @Override
        public void addCell(BigDecimal bigDecimal, int n, String string) {
            this.addCell((Object)Float.valueOf(bigDecimal.setScale(n, 4).floatValue()), string);
        }
    }

    public class BodyRow
    extends JS {
        static final int ROUNDING = 4;
        JsArray cells = new JsArray();
        JsonObject trAttr = new JsonObject();

        @Override
        public void write(PrintWriter printWriter) throws Exception {
            if (this.trAttr.isEmpty()) {
                this.cells.write(printWriter);
            } else {
                new JsonObject(new String[]{"tr", "td"}, new Object[]{this.trAttr, this.cells}).write(printWriter);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.cells.isEmpty();
        }

        public void addRowStyle(String string) {
            this.trAttr.set(Grid.STYLE, (Object)string);
        }

        public void addCell(Object object, Object object2, Object object3) {
            if (object2 == null && object3 == null) {
                this.cells.push(object);
            } else {
                JsonObject jsonObject = new JsonObject(Grid.DISPLAY, object);
                if (object2 != null) {
                    jsonObject.set(Grid.UID, object2);
                }
                if (object3 != null) {
                    jsonObject.set(Grid.SORT, object3);
                }
                this.cells.push(jsonObject);
            }
        }

        public void addCell(Object object, String[] stringArray) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.STYLE}, new Object[]{object, new JsArray(stringArray)}));
        }

        public void addCell(Object object, String string) {
            this.addCell(object, new String[]{string});
        }

        public void addCell(Object object, JsonObject jsonObject) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.ATTRIBUTES}, new Object[]{object, jsonObject}));
        }

        public void addCell(Object object, JsonObject jsonObject, boolean bl) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.ATTRIBUTES, Grid.EDITOR}, new Object[]{object, jsonObject, bl}));
        }

        public void addCell(Object object, boolean bl) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.EDITOR}, new Object[]{object, bl}));
        }

        public void addCell(String string) {
            this.cells.push(string);
        }

        public void addCell(Object object) {
            this.cells.push(object);
        }

        public void addCell(int n) {
            this.cells.push(StringX.formatCommas((String)String.valueOf(n)));
        }

        public void addCellUnformatted(Long l) {
            this.cells.push((long)l);
        }

        public void addCell(float f) {
            this.cells.push(StringX.formatCommas((float)f));
        }

        public void addCell(BigDecimal bigDecimal, int n) {
            this.addCell(bigDecimal.setScale(n, 4).floatValue());
        }

        public void addCell(BigDecimal bigDecimal, int n, String[] stringArray) {
            this.addCell((Object)Float.valueOf(bigDecimal.setScale(n, 4).floatValue()), stringArray);
        }

        public void addCell(BigDecimal bigDecimal, int n, String string) {
            this.addCell((Object)Float.valueOf(bigDecimal.setScale(n, 4).floatValue()), string);
        }

        public void addCellAsSortableString(String string, String string2) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.SORT}, new Object[]{string, string2}));
        }

        public void addCellAsSortableString(String string, String string2, JsonObject jsonObject) {
            this.cells.push(new JsonObject(new String[]{Grid.DISPLAY, Grid.SORT, Grid.ATTRIBUTES}, new Object[]{string, string2, jsonObject}));
        }
    }
}

