/*
 * Decompiled with CFR 0.152.
 */
package net.model3.javascript;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.model3.javascript.JS;

public class JsonObject
extends JS {
    private ArrayList<String> _labels = new ArrayList();
    private ArrayList<Object> _values = new ArrayList();

    public JsonObject() {
    }

    public JsonObject(String[] stringArray, Object[] objectArray) {
        if (stringArray.length != objectArray.length) {
            throw new RuntimeException("labels & values must have identical length");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.set(stringArray[i], objectArray[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this._labels.size() == 0;
    }

    public int size() {
        return this._values.size();
    }

    public JsonObject(String string, Object object) {
        this(new String[]{string}, new Object[]{object});
    }

    private int indexOf(String string) {
        for (int i = 0; i < this._labels.size(); ++i) {
            String string2 = this._labels.get(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void set(String string, Object object) {
        int n = this.indexOf(string = string.trim());
        if (n == -1) {
            this._labels.add(string);
            this._values.add(object);
        } else {
            this._values.remove(n);
            this._values.add(n, object);
        }
    }

    public void set(long l, Object object) {
        this.set(String.valueOf(l), object);
    }

    public Object getLabel(int n) {
        return this._labels.get(n);
    }

    public Object getValue(int n) {
        return this._values.get(n);
    }

    public Object get(String string) {
        int n = this.indexOf(string);
        if (n > -1) {
            return this._values.get(n);
        }
        return null;
    }

    public void delete(String string) {
        int n = this.indexOf(string);
        if (n > -1) {
            this._labels.remove(n);
            this._values.remove(n);
        }
    }

    public void push(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            this.set(String.valueOf(i), objectArray[i]);
        }
    }

    @Override
    public void write(PrintWriter printWriter) throws Exception {
        printWriter.append("{");
        if (!this.isEmpty()) {
            printWriter.append(JsonObject.asLabel(this._labels.get(0)) + ":" + JsonObject.asValue(this._values.get(0)));
            for (int i = 1; i < this._labels.size(); ++i) {
                printWriter.append("," + JsonObject.asLabel(this._labels.get(i)) + ":" + JsonObject.asValue(this._values.get(i)));
            }
        }
        printWriter.append("}");
    }
}

